package cn.quantgroup.xyqb.controller.internal.user;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author xufei on 2018/1/5.
 */
@RestController
@RequestMapping("/user/auth")
public class UserAuthorizedController{

    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthorizedController.class);

    @Resource
    private IUserAuthorizedService userAuthorizedService;

    @RequestMapping(value="/hasUserAuthorized",method = RequestMethod.GET)
    public Boolean  hasUserAuthorized(String idNo){
        LOGGER.info("[hasUserAuthorized]需要校验的用户的身份证号为idNo:{}",idNo);
        return userAuthorizedService.hasUserAuthorized(idNo);
    }

    @RequestMapping(value = "/createUserAuthorized",method = RequestMethod.POST)
    public String createUserAuthorized(@RequestParam Map<String,String> parameters){
        LOGGER.info("[createUserAuthorized]创建实名账户,parameters:{}",parameters);
        return userAuthorizedService.createUserAuthorized(parameters);
    }

    @RequestMapping(value = "/getUserAuthorizedId",method = RequestMethod.GET)
    public Long getUserAuthorizedId(Long userId){
        LOGGER.info("[getUserAuthorizedId]获取实名账户的id，userId:{}",userId);
        return userAuthorizedService.getUserAuthorizedId(userId);
    }
}
