package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.constant.enums.LoginType;
import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.v2.login.BaseLoginParam;
import cn.quantgroup.xyqb.model.v2.login.SMSDirectLoginParam;
import cn.quantgroup.xyqb.remote.JiGuangRemoteService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.ILockIpv4Service;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.UUID;

/**
 * 极光一键登录
 */
@Service
@Slf4j
public class SMSDirectJiLoginStrategy implements LoginStrategy {
    private final ILockIpv4Service lockIpv4Service;
    private final IUserService userService;
    private final ISessionService sessionService;
    @Value("${sc.is.open:false}")
    private Boolean scIsOpen;

    private final ISensorsAnalytics iSensorsAnalytics;

    private final JiGuangRemoteService jiGuangRemoteService;

    private final IUserRegisterService userRegisterService;

    public SMSDirectJiLoginStrategy(ILockIpv4Service lockIpv4Service, IUserService userService, ISessionService sessionService, ISensorsAnalytics iSensorsAnalytics, JiGuangRemoteService jiGuangRemoteService, IUserRegisterService userRegisterService) {
        this.lockIpv4Service = lockIpv4Service;
        this.userService = userService;
        this.sessionService = sessionService;
        this.iSensorsAnalytics = iSensorsAnalytics;
        this.jiGuangRemoteService = jiGuangRemoteService;
        this.userRegisterService = userRegisterService;
    }

    @Override
    public Integer getType() {
        return 1201;
    }

    @Override
    public LoginBean login(BaseLoginParam param) {
        SMSDirectLoginParam smsLoginParam = (SMSDirectLoginParam) param;
        SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();

        JiGuangRequestParam jiGuangRequestParam = new JiGuangRequestParam();
        JiGuangResponseParam jiGuangResponseParam;
        jiGuangRequestParam.setLoginToken(smsLoginParam.getToken());
        jiGuangRequestParam.setExID(UUID.randomUUID().toString());
        // 执行极验验证码检查
        if (ClientType.APP.equals(ClientType.valueByCode(smsLoginParam.getClientType()))) {
            jiGuangResponseParam = jiGuangRemoteService.webLoginTokenVerify(jiGuangRequestParam);
        } else {
            jiGuangResponseParam = jiGuangRemoteService.h5LoginTokenVerify(jiGuangRequestParam);
        }

        if (jiGuangResponseParam == null || 8000 != jiGuangResponseParam.getCode()) {
            throw new BizException(BizExceptionEnum.ERROR_DIRECT_LOGIN);
        }else{
            smsLoginParam.setPhone(jiGuangResponseParam.getPhone());
        }


        User user = userService.findByPhoneWithCache(smsLoginParam.getPhone(), sessionStruct.getTenantId());
        //需要返回用户是否首次注册
        boolean register = user == null;
        if (user != null && !user.getEnable()) {
            log.info("用户不存在，或者已经注销，phoneNo:{}", smsLoginParam.getPhone());
            throw new BizException(BizExceptionEnum.ERROR_OR_ENABLE_ERROR);
        }
        if (scIsOpen) {
            try {
                if (!StringUtils.isEmpty(sessionStruct.getScDeviceId())) {
                    iSensorsAnalytics.trackSignUp(user.getUuid(), sessionStruct.getScDeviceId());
                }
                if (!StringUtils.isEmpty(sessionStruct.getTerminal()) && "APP".equals(sessionStruct.getTerminal()) || sessionStruct.getRegisteredFrom() != null && (214 == sessionStruct.getRegisteredFrom() || 217 == sessionStruct.getRegisteredFrom())) {

                    EventRecord userRecord = EventRecord.builder().setDistinctId(user.getUuid()).isLoginId(Boolean.TRUE)
                            .setEventName("App_RegisterEvent")
                            .build();
                    iSensorsAnalytics.track(userRecord);

                    iSensorsAnalytics.flush();
                } else {
                    log.info("老神策埋点{},{}------------", user.getRegisteredFrom(), user.getUuid());
                    EventRecord userRecord = EventRecord.builder().setDistinctId(user.getUuid()).isLoginId(Boolean.TRUE)
                            .setEventName("PD_WUXIEC_UserLoginVccorCash")
                            .addProperty("son_channel_id", user.getRegisteredFrom())
                            .addProperty("parent_channel_id", -1L)
                            .addProperty("vcccash_uuid", user.getUuid())
                            .build();
                    iSensorsAnalytics.track(userRecord);
                    iSensorsAnalytics.flush();
                }
            } catch (Exception e) {
                log.info("神策埋点出现问题", e);
            }
        }


        LoginProperties loginProperties = new LoginProperties(1, sessionStruct.getRegisteredFrom(), sessionStruct.getTenantId());
        AuthBean authBean = sessionService.createSession(user, loginProperties, LoginType.AUTHLOGIN.ordinal(), sessionStruct.getTenantId(),false);
        LoginBean loginBean = new LoginBean();
        if (authBean != null) {
            loginBean.setToken(authBean.getToken());
            loginBean.setPhoneNo(authBean.getPhoneNo());
            loginBean.setUuid(authBean.getUuid());
            loginBean.setHasPassword(authBean.isHasPassword());
            loginBean.setUserId(user.getId());
            loginBean.setTenantId(user.getTenantId());
        }
        loginBean.setRegister(register);
        lockIpv4Service.unLockPhone(smsLoginParam.getPhone());

        return loginBean;
    }

    @Override
    public BaseLoginParam checkParam(LoginReq loginReq) {
        SMSDirectLoginParam param = loginReq.getData().toJavaObject(SMSDirectLoginParam.class);
        param.setClientType(loginReq.getClientType());
        validator.validate(param);
        return param;
    }
}
