package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import lombok.Data;

import java.io.Serializable;
import java.util.Optional;

/**
 * user完整数据模型，包括user，user_detail
 */
@Data
public class UserFullInfo implements Serializable {

    private static final long serialVersionUID = -1L;

    private Long id;

    private String name;

    private String phoneNo;

    private String idNo;

    private String gender;

    private String password;

    private Long registerFrom;

    private String uuid;

    private Boolean enable;

    public UserFullInfo() {
    }

    public UserFullInfo(User user, UserInfoEntity userInfoEntity) {
        if (user != null) {
            this.id = user.getId();
            this.phoneNo = user.getPhoneNo();
            this.registerFrom = user.getRegisteredFrom();
            this.password = user.getPassword();
            this.uuid = user.getUuid();
            this.enable = user.getEnable();
        }
        if (userInfoEntity != null) {
            this.name = userInfoEntity.getName();
            this.gender = Optional.ofNullable(userInfoEntity.getGender()).orElse(Gender.UNKNOWN).getName();
        }
    }

}
