package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.controller.internal.user.resp.UserFullResp;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.UserInfo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface IUserService {

    User findByPhoneWithCache(String phone,Integer tenantId);

    User findByUuidWithCache(String uuid,Integer tenantId);

    boolean exist(String phoneNo,Integer tenantId);

    boolean resetPassword(String phoneNo, String password,Integer tenantId);

    User findByPhoneInDb(String phone,Integer tenantId);

    User findSlaveByPhoneInDb(String phone,Integer tenantId);

    User findByUuidInDb(String uuid,Integer tenantId);

    /**
     * 根据手机号或身份证号查询用户UUID
     *
     * @param phoneNo - 手机号
     * @return user表的uuid
     */
    String findUuid(String phoneNo,Integer tenantId);

    Map<Long, String> findPhoneByIdsInDb(List<Long> userIds, Integer tenantId);

    User saveUser(User user);

    User findById(Long userId,Integer tenantId);

    List<User> findByPhones(List<String> phones,Integer tenantId);

    List<User> findRegisterUserByTime(String beginTime, String endTime,Integer tenantId);

    /**
     * 禁用用户
     *
     * @param phoneNo 电话号码
     */
    int forbiddenUser(Boolean enable, String phoneNo,Integer tenantId);

    List<UserInfo> findUserInfosByPhones(List<String> phones, Integer tenantId);

    /**
     * 修改手机号码.
     *
     * @param oldPhoneNo 旧手机号
     * @param newPhoneNo 新手机号
     * @return 返回用户信息
     */
    User modifyPhoneNo(String oldPhoneNo, String newPhoneNo,Integer tenantId);

    /**
     * 删除这个用户相关缓存
     *
     * @param uuid    根据 uuid
     * @param phoneNo 根据手机号
     */
    void userCacheEvict(String uuid, String phoneNo,Integer tenantId);

    JsonResult loginFast(Long channelId, String appChannel, Long createdFrom, Long btRegisterChannelId,
                         String dimension, String clickId, HttpServletRequest request, Merchant merchant,
                         String phoneNo, Integer tenantId, Long geetestLogId,String appId);

    /**
     * 查询用户全量信息
     *
     * @param userId 用户id
     * @return
     */
    UserFullResp findUserFullSearchByUserId(Long userId,Integer tenantId);

    /**
     * 按照userid 或者 uuid 批量查询
     *
     * @param vals
     * @param type
     * @return
     */
    List<User> findByUuidsOrUserIds(List<String> vals, Integer type, Integer tenantId);

    /**
     * 登出
     */
    void logout(String token,Integer tenantId);

    void kdspLogout(Long userId, LoginProperties loginProperties,Integer tenantId);

    /**
     * 通过userId销户
     *
     * @param userId 用户id
     */
    void deregister(Long userId,Integer tenantId);

    User submitModifyPhone(String prevPhoneNo, String curPhoneNo,Integer tenantId);

    /**
     * 渠道用户签署合同
     */
    void channelUserSignContract(User user, Long loginFrom,Integer tenantId);
}
