package cn.quantgroup.xyqb.service.middleoffice.applet.impl;

import cn.quantgroup.xyqb.config.data.WechatConfiguration;
import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.middleoffice.login.ILoginModule;
import cn.quantgroup.xyqb.controller.middleoffice.login.LoginVo;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatBindLog;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.entity.middleoffice.AppletParamEntry;
import cn.quantgroup.xyqb.entity.middleoffice.UnbindParam;
import cn.quantgroup.xyqb.exception.AppletException;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.repository.IWeChatUserRepository;
import cn.quantgroup.xyqb.repository.IWechatBindLogRepository;
import cn.quantgroup.xyqb.service.middleoffice.applet.IAppletService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.session.impl.SessionServiceImpl;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.qiniu.util.Json;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindException;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static cn.quantgroup.xyqb.constant.UserConstant.USER_FREEZE_ERROR;


/**
 * @author ：dongjianhua
 * @date ：Created in 2020/5/27 17:27
 * @description：小程序服务层
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@Service
public class AppletServiceImpl implements IAppletService {


    private final IWeChatUserRepository iWeChatUserRepository;
    private final IUserRegisterService iUserRegisterService;
    private final IUserService userService;
    private ILoginModule loginModule;
    private final WechatConfiguration wechatConfiguration;
    private final IWechatBindLogRepository wechatBindLogRepository;

    private final ISessionService sessionService;


    @Autowired
    public AppletServiceImpl(IWeChatUserRepository iWeChatUserRepository,
                             IUserRegisterService iUserRegisterService,
                             IUserService userService,
                             ILoginModule loginModule, WechatConfiguration wechatConfiguration,
                             IWechatBindLogRepository wechatBindLogRepository, ISessionService sessionService) {
        this.iWeChatUserRepository = iWeChatUserRepository;
        this.iUserRegisterService = iUserRegisterService;
        this.userService = userService;
        this.loginModule = loginModule;
        this.wechatConfiguration = wechatConfiguration;
        this.wechatBindLogRepository = wechatBindLogRepository;
        this.sessionService = sessionService;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long relevance(AppletParamEntry appletParamEntry) {
        String appId = wechatConfiguration.getByAppName(appletParamEntry.getAppName()).getAppId();
        appId = StringUtils.isEmpty(appletParamEntry.getAppId()) ? appId:appletParamEntry.getAppId();
        if (!StringUtils.isEmpty(appletParamEntry.getAppId()) && !Objects.equals(appId,appletParamEntry.getAppId())) {
            throw new BizException(BizExceptionEnum.ERROR_MATCHING_WECHAT_APP_ID);
        }
        appletParamEntry.setAppId(appId);
        // 校验当前用户的手机号有没有绑定过openId
        List<WechatUserInfo> wechatUserInfos = iWeChatUserRepository.findByPhoneNoAndAppNameAndAppIdAndTenantId(appletParamEntry.getMobile(),
                appletParamEntry.getAppName(), appletParamEntry.getAppId(), appletParamEntry.getTenantId());

        if(wechatUserInfos.size()>1){
            log.info("微信关联失败[service]:phoneNo:{},openId:{}，appName:{}",  appletParamEntry.getMobile(), appletParamEntry.getOpenId(),appletParamEntry.getAppName());
            throw new AppletException(BizExceptionEnum.USER_WECHAT_BIND_ERROR.getMsg(), BizExceptionEnum.USER_WECHAT_BIND_ERROR.getBusinessCode());
        }
        if(wechatUserInfos.size() ==1){
            WechatUserInfo wechatUserInfoOne = wechatUserInfos.get(0);
            if(Objects.equals(wechatUserInfoOne.getOpenId(),appletParamEntry.getOpenId())){
                log.info("微信关联成功：重复关联：跳过：[service]:userId:{},phoneNo:{},openId:{}", wechatUserInfoOne.getUserId(), wechatUserInfoOne.getPhoneNo(), wechatUserInfoOne.getOpenId());
                return wechatUserInfoOne.getUserId();
            }else{
                log.info("微信关联失败[service]:phoneNo:{},openId:{}，appName:{}",  appletParamEntry.getMobile(), appletParamEntry.getOpenId(),appletParamEntry.getAppName());
                throw new AppletException(BizExceptionEnum.USER_WECHAT_BIND_ERROR.getMsg(), BizExceptionEnum.USER_WECHAT_BIND_ERROR.getBusinessCode());
            }
        }

        WechatUserInfo wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppNameAndAppIdAndTenantId(appletParamEntry.getOpenId(), appletParamEntry.getAppName(), appletParamEntry.getAppId(), appletParamEntry.getTenantId());
        //这个接口先不考虑更换手机号的情况
        if (appletParamEntry.getTenantId() == null) {
            appletParamEntry.setTenantId(UserConstant.defaultTenantId);
        }


        wechatUserInfo = (wechatUserInfo == null ? new WechatUserInfo() : wechatUserInfo);
        wechatUserInfo.setNickName(appletParamEntry.getNickName());
        wechatUserInfo.setCity(appletParamEntry.getCity());
        wechatUserInfo.setCountry(appletParamEntry.getCountry());
        wechatUserInfo.setProvince(appletParamEntry.getProvince());
        wechatUserInfo.setAppName(appletParamEntry.getAppName());
        wechatUserInfo.setHeadImgUrl(appletParamEntry.getAvatarUrl());
        wechatUserInfo.setLanguage(appletParamEntry.getLanguage());
        wechatUserInfo.setOpenId(appletParamEntry.getOpenId());
        wechatUserInfo.setSex(appletParamEntry.getGender());
        wechatUserInfo.setUnionId(appletParamEntry.getUnionId());
        wechatUserInfo.setPhoneNo(appletParamEntry.getMobile());
        wechatUserInfo.setEncryptedPhoneNo(appletParamEntry.getMobile());
        wechatUserInfo.setUtmSource(appletParamEntry.getUtmSource());
        wechatUserInfo.setTenantId(appletParamEntry.getTenantId());
        if (null == wechatUserInfo.getUserId()) {//只要存在userid 就说明已经在用户表里了 不考虑小程序这边换手机号了
            User user = userService.findByPhoneInDb(appletParamEntry.getMobile(), appletParamEntry.getTenantId());
            //如果不存在就去注册一下
            if (null == user) {
                user = iUserRegisterService.register(appletParamEntry.getChannelId(), appletParamEntry.getMobile());
            }
            if (!user.getEnable()) {
                log.warn("已冻结 userId--{}", user.getId());
                throw new AppletException(USER_FREEZE_ERROR, "0402");
            }
            wechatUserInfo.setUserId(user.getId());
        }
        wechatUserInfo.setAppId(appId);

        //如果存在就更新在微信表里
        //iWeChatUserRepository.findByOpenIdAndAppNameAndTenantId()
        iWeChatUserRepository.save(wechatUserInfo);
        // 记录微信绑定记录
        WechatBindLog wechatBindLog = new WechatBindLog(wechatUserInfo.getUserId(), wechatUserInfo.getOpenId(), wechatUserInfo.getAppName(),
                appId, wechatUserInfo.getTenantId(), wechatUserInfo.getUnionId(),1 );
        wechatBindLogRepository.save(wechatBindLog);
        return wechatUserInfo.getUserId();
    }


    @Override
    public LoginVo login(String appName, String openId, Integer tenantId, String utmSource, String unionId, String appId) {
        WechatUserInfo wechatUserInfo;
        if (StringUtils.isEmpty(appId)) {
            wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppNameAndTenantId(openId, appName, tenantId);
        } else {
            wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppIdAndTenantId(openId, appId, tenantId);
        }
        if (null == wechatUserInfo) {
            log.warn("未找到此用户,appName:{} ,openId:{}", appName, openId);
            throw new AppletException("未找到此用户", "0401");
        }
        if (null == wechatUserInfo.getUserId()) {
            log.warn("用户未绑定到xyqb,appName:{} ,openId:{}", appName, openId);
            throw new AppletException("未找到此用户绑定信息", "0401");
        }
        appId = wechatUserInfo.getAppId();
        User user = userService.findById(wechatUserInfo.getUserId(), wechatUserInfo.getTenantId());
        if (null == user) {
            log.warn("未找到此用户,appName:{} ,openId:{}", appName, openId);
            throw new AppletException("未找到此用户", "0401");
        }

        if (!user.getEnable()) {
            log.warn("已冻结,appName:{} ,openId:{}", appName, openId);
            throw new AppletException(USER_FREEZE_ERROR, "0402");
        }

        if (unionId != null && !unionId.equals(wechatUserInfo.getUnionId())) {
            iWeChatUserRepository.updateUserUnionId(wechatUserInfo.getUserId(), appName, unionId, appId, tenantId);
        }

        return loginModule.loginByUserId(user.getRegisteredFrom(),
                utmSource == null ? "" : utmSource, user.getId(), tenantId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean unbind(UnbindParam unbindParam) {
        log.info("微信解绑,unbindParam:{} ", JSON.toJSONString(unbindParam));
        // 获取当前用户绑定了对应的微信小程序
        List<WechatUserInfo> wechatUserInfoList = iWeChatUserRepository.findByUserIdAndAppNameAndAppIdAndTenantId(unbindParam.getUserId(), unbindParam.getAppName(),
                unbindParam.getAppId(), unbindParam.getTenantId());
        if(CollectionUtils.isEmpty(wechatUserInfoList)){
            log.info("用户没有微信绑定记录,appName:{} ,phone:{},userId:{}", unbindParam.getAppName(), unbindParam.getPhone(),unbindParam.getUserId());
            return true;
        }
        // 删除微信关联记录，并记录解绑记录
        for (WechatUserInfo wechatUserInfo : wechatUserInfoList) {
            WechatBindLog wechatBindLog = new WechatBindLog(wechatUserInfo.getUserId(), wechatUserInfo.getOpenId(), wechatUserInfo.getAppName(),
                            wechatUserInfo.getAppId(), wechatUserInfo.getTenantId(), wechatUserInfo.getUnionId(),2);
            log.info("删除微信绑定记录,wechatUserInfo:{}", JSON.toJSONString(wechatUserInfo));
            iWeChatUserRepository.deleteById(wechatUserInfo.getId());
            wechatBindLogRepository.save(wechatBindLog);
        }
        // 删除微信关联记录后，清除微信渠道的登陆token
        if(org.apache.commons.lang3.StringUtils.isNotEmpty(unbindParam.getWechatChannelId())){
            List<String> wechatChannelIds = Arrays.stream(unbindParam.getWechatChannelId().split(",")).collect(Collectors.toList());
            for (String wechatChannelId : wechatChannelIds) {
                LoginProperties loginProperties = new LoginProperties(1, Long.valueOf(wechatChannelId), unbindParam.getTenantId());
                sessionService.deleteWechatSession(unbindParam.getUserId(),loginProperties,unbindParam.getTenantId());
                log.info("微信解绑成功,清除微信的登陆token，userId:{},wechatChannelId:{}", unbindParam.getUserId(),wechatChannelId);
            }
        }
        User user = userService.findById(unbindParam.getUserId(), unbindParam.getTenantId());
        // 老的微信登录的时候用的是下边的方式,删除的时候也只能这么删
        LoginProperties loginProperties = LoginProperties.builder()
                .createdFrom(user.getRegisteredFrom())
                .tenantId(unbindParam.getTenantId())
                .build();
        sessionService.deleteWechatSession(unbindParam.getUserId(),loginProperties,unbindParam.getTenantId());
        log.info("微信解绑成功,清除微信的登陆token，userId:{},loginProperties:{}", unbindParam.getUserId(), JSON.toJSONString(loginProperties));
        return true;
    }


}
