package cn.quantgroup.xyqb.util;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterMqMessage;
import cn.quantgroup.xyqb.model.UserRet;
import cn.quantgroup.xyqb.model.UserStatistics;
import cn.quantgroup.xyqb.service.mq.IRegisterMqService;
import cn.quantgroup.xyqb.service.mq.IVestService;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by xuran on 2017/6/23.
 */
@Slf4j
public class MqUtils {
  /**
   * 发送用户统计信息
   * @param vest
   */
  public static void sendLoanVest(UserStatistics vest){
    try {
      IVestService mqService = ApplicationContextHolder.getBean("loanVestMQService");
      mqService.send(vest);
    } catch (Exception e) {
      log.error("[MQUtils][MQUtils_exception]发送用户统计信息，vest={},error={}",
          vest, e);
    }
  }
  /**
   * 用户注册消息进行广播
   * @param message
   */
  public static void sendRegisterMessage(UserRegisterMqMessage message){
    try {
      IRegisterMqService rService = ApplicationContextHolder.getBean("registerMqService");
      rService.send(message);
    } catch (Exception e) {
      log.error("[MQUtils][MQUtils_exception]发送用户注册广播信息，message={},error={}",
          message, e);
    }
  }

  public static UserRet sendRegisterMessage(Long registeredFrom, User user) {
    UserRet userRet;
    UserStatistics statistics=new UserStatistics(user,null,2,registeredFrom);
    MqUtils.sendLoanVest(statistics);
    userRet = new UserRet(user);
    //增加用户注册广播
    UserRegisterMqMessage registerMqMessage=new UserRegisterMqMessage(user);
    MqUtils.sendRegisterMessage(registerMqMessage);
    return userRet;
  }
}
