package cn.quantgroup.xyqb.urora;

import cn.quantgroup.xyqb.security.RSADecrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * Created by Administrator on 2021/7/1 0001.
 */
@Component(value="UroraAuthenticationManager")
public class UroraAuthenticationManager implements AuthenticationManager {

    private static final Logger logger = LoggerFactory.getLogger(UroraAuthenticationManager.class);
    @Autowired
    private RestTemplate restTemplate;
    private HttpHeaders headers;

    @Value("${user.auth.manager.Urora.properties.authorization}")
    private String authorization;

    @Value("${user.auth.manager.Urora.properties.loginTokenVerify}")
    private String appUrl;

    @Value("${user.auth.manager.jiguang.auth.web}")
    private String webUrl;

    @Value("${user.auth.manager.Urora.properties.privateKey}")
    private String key;

    @PostConstruct
    public void init() {
        this.headers = new HttpHeaders();
        this.headers.add("Authorization", authorization);
        this.headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        List<HttpMessageConverter<?>> messageConverters = restTemplate.getMessageConverters();
        MappingJackson2HttpMessageConverter stringHttpMessageConverter = new MappingJackson2HttpMessageConverter();
        stringHttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8, MediaType.TEXT_PLAIN));
        messageConverters.add(stringHttpMessageConverter);
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        HttpEntity<String> httpEntity = new HttpEntity<>("{\"loginToken\":\"" + authentication.getCredentials() + "\"}", headers);
        try {
            String url = appUrl;
            if(Objects.nonNull(authentication.getPrincipal()) && (authentication.getPrincipal().equals("operatorWeb"))){
                url = webUrl;
            }
            ResponseEntity<UroraResponse> verify = restTemplate.postForEntity(url, httpEntity, UroraResponse.class);
            if (HttpStatus.OK.equals(verify.getStatusCode())) {
                UroraResponse body = verify.getBody();
                if (!body.getCode().equals("8000") || StringUtils.isEmpty(body.getPhone())) {
                    logger.warn("Urora login token verify failed. {}", body);
                    authentication.setAuthenticated(false);
                } else {
                    String decrypt = RSADecrypt.decrypt(body.getPhone(), key);
                    UroraAuthenticationToken token = new UroraAuthenticationToken(body.getId(), decrypt);
                    token.setAuthenticated(true);
                    return token;
                }
            }
        } catch (Exception e) {
            logger.error("Urora login token verify failed. " + e.getMessage(), e);
            authentication.setAuthenticated(false);
        }
        return authentication;
    }
}