package cn.quantgroup.xyqb.event;

import cn.quantgroup.acolyte.buddhistscriptures.ingester.UserIngest;
import cn.quantgroup.acolyte.buddhistscriptures.pojo.UserRealInfo;
import cn.quantgroup.xyqb.entity.UserDetail;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 用户保存或更新 userDetail 时发送统计信息
 */
@Component
public class UserDetailStatisticsEventListener implements ApplicationListener<UserDetailUpdateEvent> {

    @Resource
    private UserIngest userIngest;


    @Override
    public void onApplicationEvent(UserDetailUpdateEvent event) {
        UserDetail userDetail = event.getUserDetail();

        UserRealInfo userRealInfo = new UserRealInfo();
        userRealInfo.setUserId(userDetail.getUserId());
        userRealInfo.setIdType(userDetail.getIdType().ordinal());
        userRealInfo.setName(userDetail.getName());
        userRealInfo.setIdNo(userDetail.getIdNo());

        userIngest.sendUserRealInfo(userRealInfo);
    }
}
