package cn.quantgroup.xyqb.interceptors;

import cn.quantgroup.xyqb.util.IPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 内部服务白名单拦截器
 * Created by Administrator on 2017/5/9.
 * @Modify by renwc
 * @date 2017-12-06
 */
public class IPWhiteListInterceptor implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPWhiteListInterceptor.class);
    private Integer isDebug;

    public IPWhiteListInterceptor(Integer isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if(isDebug !=0){
            return true;
        }
        String remoteIP = IPUtil.getRemoteIP(request);
        if(IPUtil.whiteOf(remoteIP)) {
            return true;
        }
        LOGGER.info("Lock_ipv4: don't match white ip access:{}",remoteIP);
        return false;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {

    }
}
