package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IModifyPhoneNoRepository extends JpaRepository<ModifyPhoneNo, Long>, JpaSpecificationExecutor<ModifyPhoneNo> {

    @Query(nativeQuery = true, value = "select * from user_modify_phone_no " +
            "where user_id = :userId and (apply_status is null or apply_status = :applyStatus)" +
            "limit 1")
    ModifyPhoneNo findFirstByUserIdAndApplyStatus(@Param("userId") Long userId,
                                                          @Param("applyStatus") Integer applyStatus);
}
