package cn.quantgroup.xyqb.service.user.vo;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class UserDetailVO {
  private Long id;

  private Long userId;

  private String phoneNo;

  private String name;

  private String idNo;

  private IdType idType;

  private Boolean isAuthenticated = false;

  private Gender gender;

  private String email;

  private String qq;

  private Boolean enable;

  private Long createdAt;

  private Long updatedAt;


  public static UserDetailVO fromUserDetail(UserDetail userDetail) {
    UserDetailVO userDetailVO = new UserDetailVO();
    userDetailVO.id = userDetail.getId();
    userDetailVO.userId = userDetail.getUserId();
    userDetailVO.phoneNo = userDetail.getPhoneNo();
    userDetailVO.name = userDetail.getName();
    userDetailVO.idNo = userDetail.getIdNo();
    userDetailVO.idType = userDetail.getIdType();
    userDetailVO.isAuthenticated = userDetail.getIsAuthenticated();
    userDetailVO.gender = userDetail.getGender();
    userDetailVO.email = userDetail.getEmail();
    userDetailVO.qq = userDetail.getQq();
    if (userDetail.getCreatedAt() != null) {
      userDetailVO.createdAt = userDetail.getCreatedAt().getTime();
    }
    if (userDetail.getUpdatedAt() != null) {
      userDetailVO.updatedAt = userDetail.getUpdatedAt().getTime();
    }
    return userDetailVO;
  }
}
