package cn.quantgroup.xyqb.controller.external.captcha;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.service.captcha.IGeetestLogService;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.util.IpUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * @author xufei on 2018/1/30.
 */
@Slf4j
@RestController
@RequestMapping("/api")
public class NewCaptchaController {

    @Resource
    private IGeetestCaptchaService geetestCaptchaService;
    @Resource
    private IQuantgroupCaptchaService quantgroupCaptchaService;
    @Value("${geetest.close:false}")
    private String geetestClose;

    @Resource
    private IGeetestLogService geetestLogService;



    @RequestMapping(value = "/captcha/new")
    @ApiOperation(value = "获取新图形验证码", notes = "获取新图形验证码", httpMethod = "POST")
    public JsonResult getCaptcha(String phoneNo, String clientType, String settingType, HttpServletRequest request) {
        String remoteIp = IpUtil.getRemoteIP(request);
        log.info("获取验证码, phoneNo:{}, clientType:{}, ip:{}, verifyType-qg:{}", phoneNo, clientType, remoteIp, geetestClose);

        if (StringUtils.isNotBlank(phoneNo) && !ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult("手机号格式错误", null);
        }

        if (settingType != null) {
            if (StringUtils.isNotBlank(phoneNo) || !ValidationUtil.validatePhoneNo(phoneNo)) {
                return JsonResult.buildErrorStateResult("手机号格式错误", null);
            }
        }
        // 唯一key,用于初始化极验
        String key = StringUtils.isNotBlank(phoneNo) ? phoneNo.trim() : UUID.randomUUID().toString();
        // key指纹
        String keyMd5 = PasswordUtil.MD5(key);
        log.info("获取验证码, phoneNo:{}, keyMd5:{}, clientType:{}, ip:{}, verifyType-qg:{}", phoneNo, keyMd5, clientType, remoteIp, geetestClose);
        // 数据容器
        Map<String, String> data = new HashMap<>();
        Map<String, String> imgMap = null;
        // 优先获取极验
        Long geetestLogId = 0L;
        if (!Boolean.valueOf(geetestClose)) {
            imgMap = geetestCaptchaService.fetchGeetestCaptcha(keyMd5, remoteIp, ClientType.valueByName(clientType));
            data.put(Constants.VERIFY_PARAM, Constants.VERIFY_TYPE_GT);
            // 存储极验日志，phone_no, datasource, setting, challenge, captchaid
            if (settingType != null) {
                geetestLogId = geetestLogService.saveGeetestLog(phoneNo, clientType, settingType, imgMap);
            }

        }
        // 备选方案：量化派图形验证码
        if (Objects.isNull(imgMap) || imgMap.isEmpty()) {
            imgMap = quantgroupCaptchaService.fetchQuantgroupCaptcha(request.getLocale());
            data.put(Constants.VERIFY_PARAM, Constants.VERIFY_TYPE_QG);
        }
        // 返回结果
        if (Objects.isNull(imgMap) || imgMap.isEmpty()) {
            return JsonResult.buildErrorStateResult("获取验证码失败", "");
        }
        // 填充数据并返回
        data.putAll(imgMap);
        data.put(Constants.GT_UNIQUE_KEY, keyMd5);
        data.put("geetestLogId", geetestLogId.toString());
        return JsonResult.buildSuccessResult("", data);
    }

    @RequestMapping(value = "/captcha/new/passwd")
    @ApiOperation(value = "获取新图形验证码（账密）", notes = "获取新图形验证码（账密）", httpMethod = "POST")
    public JsonResult getCaptchaPasswd(String phoneNo, String clientType, String settingType, HttpServletRequest request) {
        String remoteIp = IpUtil.getRemoteIP(request);
        log.info("获取验证码, phoneNo:{}, clientType:{}, ip:{}, verifyType-qg:{}", phoneNo, clientType, remoteIp, geetestClose);
        if (StringUtils.isNotBlank(phoneNo) || !ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult("手机号格式错误", null);
        }
        // 唯一key,用于初始化极验
        String key = StringUtils.isNotBlank(phoneNo) ? phoneNo.trim() : UUID.randomUUID().toString();
        // key指纹
        String keyMd5 = PasswordUtil.MD5(key);
        log.info("获取验证码, phoneNo:{}, keyMd5:{}, clientType:{}, ip:{}, verifyType-qg:{}", phoneNo, keyMd5, clientType, remoteIp, geetestClose);
        // 数据容器
        Map<String, String> data = new HashMap<>();
        Map<String, String> imgMap = null;
        // 优先获取极验
        Long geetestLogId = 0L;
        imgMap = geetestCaptchaService.fetchGeetestCaptchaPasswd(keyMd5, remoteIp, ClientType.valueByName(clientType));
        data.put(Constants.VERIFY_PARAM, Constants.VERIFY_TYPE_GT);
        // 存储极验日志，phone_no, datasource, setting, challenge, captchaid
        geetestLogId = geetestLogService.saveGeetestLog(phoneNo, clientType, settingType, imgMap);

        // 返回结果
        if (Objects.isNull(imgMap) || imgMap.isEmpty()) {
            return JsonResult.buildErrorStateResult("获取验证码失败", "");
        }
        // 填充数据并返回
        data.putAll(imgMap);
        data.put(Constants.GT_UNIQUE_KEY, keyMd5);
        data.put("geetestLogId", geetestLogId.toString());
        return JsonResult.buildSuccessResult("", data);
    }

}
