package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.model.AuthPattern;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * @author xufei on 2018/1/5.
 */
@Data
@Entity
@Table(name = "user_authorized")
public class UserAuthorized {

    @Id
    @Column(name = "id")
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name ="uuid" , strategy = "uuid")
    private String id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "user_uuid")
    private String userUuid;

    //证件号
    @Column(name = "id_no")
    private String idNo;

    @Column(name = "name")
    private String name;

    @Column(name = "auth_pattern")
    private AuthPattern authPattern;

    @Column(name = "available")
    private Boolean available;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    //上一次修改时间
    @Column(name = "updated_at")
    private Timestamp updatedAt;

}
