package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.model.UserRegisterParam;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;

/**
 * 注册成功发送事件
 *
 * @author ag
 */
@Getter
@Setter
public class RegisterEvent extends ApplicationEvent {
    private UserRegisterParam userRegisterParam;

    /**
     * Create a new ApplicationEvent.
     *
     * @param source the object on which the event initially occurred (never {@code null})
     */
    public RegisterEvent(Object source) {
        super(source);
    }

    public RegisterEvent(Object source, UserRegisterParam userRegisterParam) {
        super(source);
        this.userRegisterParam = userRegisterParam;
    }
}
