package cn.quantgroup.xyqb.controller.external.queryLog;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserQueryLog;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.PageModel;
import cn.quantgroup.xyqb.model.UserQueryInfo;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IAddressService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserQueryLogService;

import cn.quantgroup.xyqb.util.IdcardValidator;
import cn.quantgroup.xyqb.util.ValidationUtil;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import cn.quantgroup.xyqb.util.encrypt.RSA;
import com.alibaba.fastjson.JSON;
import com.google.gson.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.*;


import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by zenglibin on 17/06/13.
 */
@RestController
@RequestMapping("/query")
public class UserQueryLogController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserQueryLogController.class);

  @Autowired
  private IUserQueryLogService userQueryLogService;
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IAddressService addressService;

  @Value("${xyqb.paycenter.url}")
  private String payCenterUrl;
  @Value("${xyqb.paycenter.id}")
  private String payCenterId;
  @Value("${xyqb.yunying.url}")
  private String yunyingUrl;



  @Autowired
  private IHttpService httpService;

  private static final String publicKey="MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCYiw1PKWnCbkKyzHK+blHpKTR/qtO3Oq7nvjSdcopCSmOJqji3B+qJMrf03242mYJIQeF3YSTQZTfri5EkNgoqn0Y/KYpLAKuq89jPdIkB3lvirvew9tpfbAT4B14WgoWdMH5ooqBt0ly3f+JjoBM5dKFTOrhckhFDoaB3UAaaiQIDAQAB";

  private static final String privateKey="MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJiLDU8pacJuQrLMcr5uUekpNH+q07c6rue+NJ1yikJKY4mqOLcH6okyt/TfbjaZgkhB4XdhJNBlN+uLkSQ2CiqfRj8piksAq6rz2M90iQHeW+Ku97D22l9sBPgHXhaChZ0wfmiioG3SXLd/4mOgEzl0oVM6uFySEUOhoHdQBpqJAgMBAAECgYA3DfCWwoaWEr9l0p4TFrPfZ+y3qwrQVZCsuRw6Ow2lUT3NgK8JeATw0WpNKZqYgBziQUzDjj8AK5fcHjobDJnsKGqC2VQ+j05hQZztoHTrYxOx6xrGxIzqmbt/dPsw779xXSRJu3DuUeCm6CrGZpVpPX/NtXBxIhXRY2KRNa1SZQJBAPMboc+M6/OeGPQqFvXg9jgEWcosBpy6HtukfjONQAVuM5e0pZa8SQCLhcoHgbbqcEhbDAJEqr9x9eZjjFPSt08CQQCgoe/hOVf0s5oo1IM1TVEUkGOIzVVlyTMwu0p4jwt3987D7BKZe7mCl41quWDwL4JIQ0GcivVMpJzYsDBZHRqnAkBMgCKAHHlXdSWnF+OXxg3U/NGAhDAke5EgTvgDouxFiTMlBwygjWlviXg1Zf1UoRtqOXRi9lbA3cyijirnacSTAkBmve0ug30MmOvbfcHGkANyQcBIOf2LMxu46bKCVgwh2bC4hACJhydqrgDX6GZmehy8l7gZpo+rTAa+WkMyXHk1AkEArt6ElkyNI7TDu0By59Zin05tuZJr6QoMXs9bVH+xP3OBG1KfPYTBc9yb5MOjXIxAjyGGeDpUfhuUDBe56GTOBA==";
  @RequestMapping("/queryLog")
  public JsonResult queryLog(HttpServletRequest request,@RequestParam(required=false) String beginDate,@RequestParam(required=false) String endDate, Integer pageId, Integer pageSize) {

    LOGGER.info("查询日期：beginDate{},endDate{}",beginDate,endDate);
    String token=request.getHeader("x-auth-token");
    if(token==null||token.equals("")){
        LOGGER.info("token为空，非法查询");
      return JsonResult.buildErrorStateResult("缺少授权信息",null);
    }

    if(checkUserToken(token).equals("")){
        LOGGER.info("token授权异常");
      return JsonResult.buildErrorStateResult("未授权查询",null);
    }
      try{
        SimpleDateFormat sf=new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sfs=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1=null,date2=null;
        if(beginDate!=null&& StringUtils.hasLength(beginDate)){
          date1=sfs.parse(beginDate+" 00:00:00");
        }else{
          String nowStr=sf.format(new Date());
          date1=sfs.parse(nowStr+" 00:00:00");
        }
        if(endDate!=null&& StringUtils.hasLength(endDate)){
          date2=sfs.parse(endDate+" 23:59:59");
        }else{
          String nowEndStr=sf.format(new Date());
          date2=sfs.parse(nowEndStr+" 23:59:59");
        }
        int startP=(pageId-1)*pageSize;
        List<UserQueryLog> userQueryLogs=userQueryLogService.findByTimestamp(date1,date2,startP,pageSize);
        Long total=userQueryLogService.findByTimestampCount(date1,date2);
        PageModel<UserQueryLog> uqp=new PageModel<UserQueryLog>();
        uqp.setTotal(total);
        if(pageSize==0||pageSize<0){
          pageSize=30;
        }else if(pageSize>200){
          pageSize=200;
        }

        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try{
          for(UserQueryLog ll:userQueryLogs){
            ll.setCreateDate(sdf.format(ll.getCreatedAt()));
          }
        }catch (Exception e){
          LOGGER.info("日期时间转换异常");
          return JsonResult.buildErrorStateResult("日期时间转换异常",null);
        }

        uqp.setPageSize(pageSize);
        uqp.setPageId(pageId);
        uqp.setPageList(userQueryLogs);
        int yu=total.intValue()%pageSize;
        Double d=Math.ceil(total/pageSize);

        uqp.setPages(yu>0?d.intValue()+1:d.intValue());
        return JsonResult.buildSuccessResult("查询成功",uqp);

      }catch(Exception e){
        return JsonResult.buildErrorStateResult("查询失败",null);
      }


  }

  @RequestMapping("/queryUserInfo")
  public JsonResult queryForResult(HttpServletRequest request,String key,String keyValues, String columns,Integer pageId,Integer pageSize) {

    LOGGER.info("查询条件：key{},columns{}",key,columns);
    String token=request.getHeader("x-auth-token");
    if(token==null||token.equals("")){
        LOGGER.info("token为空，非法查询");
      return JsonResult.buildErrorStateResult("缺少授权信息",null);
    }
    //columns=>  userId,phoneNo,idNo,bankCard,address
    //key=>phoneNo、idNo、userId
    //checkKeysType;
    //后台参数校验
    //校验用户权限
    String userName=checkUserToken(token);
    if(userName.equals("")){
        LOGGER.info("token授权异常");
      return JsonResult.buildErrorStateResult("未授权查询",null);
    }
    //输入enter换行\n
    if(org.apache.commons.lang3.StringUtils.isEmpty(keyValues)){
      return JsonResult.buildErrorStateResult("请输入查询条件",null);
    }
    String[] values=keyValues.split("\\n");
    List<String> queryV= Arrays.asList(values);

    if(queryV!=null&&queryV.size()>1000){
      return JsonResult.buildErrorStateResult("查询记录数是"+queryV.size()+",超过1000条限制",null);
    }

    List<UserQueryInfo> userQueryInfos=new ArrayList<UserQueryInfo>();
    List<UserDetail> userDetails=new ArrayList<UserDetail>();
    Page<UserDetail> userDetailPage=null;

    List<Address> addresslist=new ArrayList<Address>();
    HashMap<String,String> phonesCards=new HashMap<String,String>();

    if(pageSize==0||pageSize<0){
      pageSize=30;
    }else if(pageSize>200){
      pageSize=200;
    }

    //如果维度里面没有保护查询条件则加入条件
    if(!columns.contains(key)){
      columns=columns+","+key;
    }

    if(key.equals("userId")){
      List<Long> userIds=new ArrayList<Long>();
      try{
        for(String s:queryV){
          if(s.length()>8){

            return JsonResult.buildErrorStateResult("查询的userId"+s+"长度超过8位",null);
          }
          long uid=Long.valueOf(s);
          userIds.add(uid);
        }

      }catch(Exception e){
        return JsonResult.buildErrorStateResult("查询的userId有误",null);
      }

      userDetailPage=userDetailService.getUserDetailsPage(userIds,null,null,pageId,pageSize,"auto");
    }else if(key.equals("phoneNo")){
      for(String pn:queryV){
        if(!ValidationUtil.validatePhoneNo(pn)){
          return JsonResult.buildErrorStateResult("查询的手机号码"+pn+"格式有误",null);
        }
      }

      userDetailPage=userDetailService.getUserDetailsPage(null,queryV,null,pageId,pageSize,"auto");
    }else if(key.equals("idNo")){
      IdcardValidator iv = new IdcardValidator();
      for(String idno:queryV){
        if(!iv.is18Idcard(idno)&&!iv.is15Idcard(idno)){
          return JsonResult.buildErrorStateResult("查询的身份证号"+idno+"格式有误",null);
        }
      }
      userDetailPage=userDetailService.getUserDetailsPage(null,null,queryV,pageId,pageSize,"auto");
    }

    if(userDetailPage!=null){
      userDetails=userDetailPage.getContent();
    }

    if(columns.contains("bankCard")){
      //需加银行卡信息

      if(key.equals("phoneNo")){
        phonesCards=getBankCardsByPhoneNos(queryV);
        if(phonesCards!=null&&phonesCards.get("errorMsg")!=null&&!phonesCards.get("errorMsg").equals("")){
          return JsonResult.buildErrorStateResult(phonesCards.get("errorMsg"),null);
        }
      }else{
        List<String> phones=new ArrayList<String>();
        for(UserDetail uda:userDetails){
          phones.add(uda.getPhoneNo());
        }
        phonesCards=getBankCardsByPhoneNos(phones);
        if(phonesCards!=null&&phonesCards.get("errorMsg")!=null&&!phonesCards.get("errorMsg").equals("")){
          return JsonResult.buildErrorStateResult(phonesCards.get("errorMsg"),null);
        }
      }

    }

    if(columns.contains("address")){
      List<Long> uidss=new ArrayList<Long>();
      //加地址信息
      for(UserDetail ud:userDetails){
        uidss.add(ud.getUserId());
      }
      if(uidss!=null&&uidss.size()>0){
        addresslist=addressService.findByUserIds(uidss);
      }

    }

    for(UserDetail ud:userDetails){
      UserQueryInfo uqi=new UserQueryInfo();
      if(columns.contains("idNo")){
        uqi.setIdNo(ud.getIdNo());
      }
      if(columns.contains("phoneNo")){
        uqi.setPhoneNo(ud.getPhoneNo());
      }
      if(columns.contains("userId")){
        uqi.setUserId(ud.getUserId());
      }
      if(columns.contains("address")){
        Optional<Address> oad=addresslist.stream().filter(addr->addr.getUserId()==ud.getUserId()).findFirst();
        if(oad.isPresent()){
          uqi.setAddress(oad.get().toString());
        }
      }
      if(columns.contains("bankCard")&&phonesCards!=null){
        uqi.setBankCards(phonesCards.get(ud.getPhoneNo()));
      }

      userQueryInfos.add(uqi);

    }

    //保存记录
    UserQueryLog log=new UserQueryLog();
    log.setQueryItems(columns.replace("userId","用户ID").replace("phoneNo","手机号").replace("idNo","身份证号").replace("bankCard","银行卡号").replace("address","地址"));
    log.setResultAmount(Long.valueOf(userDetailPage.getTotalElements()));
    //转换存储
    log.setQueryCondition(key.replace("userId","用户ID").replace("phoneNo","手机号").replace("idNo","身份证号"));
    log.setQueryDetail(keyValues.replace("\n",";"));
    log.setLoginUserName(userName);
    userQueryLogService.save(log);

    PageModel<UserQueryInfo> uqi=new PageModel<UserQueryInfo>();
    uqi.setPageId(pageId);
    uqi.setPageList(userQueryInfos);
    uqi.setPageSize(pageSize);
    uqi.setPages(userDetailPage.getTotalPages());
    uqi.setTotal(userDetailPage.getTotalElements());

    return JsonResult.buildSuccessResult("查询成功",uqi);
  }

  private HashMap<String,String> getBankCardsByPhoneNos(List<String> phoneNos){
    HashMap<String,Object> ha=new HashMap<String,Object>();
    ha.put("type","1");
    ha.put("phones",phoneNos);
    String phoneNoStr= new Gson().toJson(ha);

    String data="";
    String sign="";
    HashMap<String,String> phonesMap=new HashMap<String,String>();
    try{
      data=RSA.encrypt(phoneNoStr,publicKey);
      sign= MD5Util.build(data);
    }catch(Exception e){
        LOGGER.info("参数加密异常");
        phonesMap.put("errorMsg","参数加密异常");
      return null;
    }


    HashMap<String, String> parameters = new HashMap<>();
    parameters.put("data", data);
    parameters.put("sign", sign);
    //访问用户中心查询用户银行卡接口
    String resultStr = httpService.post(payCenterUrl + "/ex/search/card_list", parameters);
    try{
      JsonObject obj = new JsonParser().parse(resultStr).getAsJsonObject();
      if(obj.get("data")!=null) {
        JsonObject data1 = obj.get("data").getAsJsonObject();
        String dataStr=data1.get("data").getAsString();
        String signStr=data1.get("sign").getAsString();
        //校验签名
        if(MD5Util.build(dataStr).equals(signStr)){
          String jsonDataStr=RSA.decrypt(dataStr,privateKey);
          JsonArray listObj = new JsonParser().parse(jsonDataStr).getAsJsonArray();
          for(JsonElement jsonElement : listObj) {
            JsonObject jo = jsonElement.getAsJsonObject();
            JsonArray cardList = jo.get("cardList").getAsJsonArray();

            String phone = jo.get("phone").getAsString();
            String cards="";
            for(JsonElement element : cardList){
              cards=cards+element.getAsString()+";";
            }
            if(cards.length()>0){
              phonesMap.put(phone,cards.substring(0,cards.length()-1));
            }

          }
        }else{
          phonesMap.put("errorMsg","签名校验失败！");
            LOGGER.info("签名校验失败！");
        }
      }
//      else{
//          phonesMap.put("errorMsg",obj.get("msg").getAsString());
//          LOGGER.info("从支付中心接口返回data为null");
//      }

    }catch(Exception e){
       phonesMap.put("errorMsg","查询银行卡信息接口返回解析异常");
        LOGGER.info("查询银行卡信息接口返回解析异常");
    }
    return phonesMap;
  }

  @RequestMapping("/exportUserInfo")
  public JsonResult exportExcel(final HttpServletResponse response, HttpServletRequest request,String key,String keyValues, String columns){


    String token=request.getHeader("x-auth-token");
    if(token==null||token.equals("")){
      LOGGER.info("token为空，非法查询");
      return JsonResult.buildErrorStateResult("缺少授权信息",null);
    }

    String userName=checkUserToken(token);
    if(userName.equals("")){
      return JsonResult.buildErrorStateResult("未授权查询",null);
    }
    //输入enter换行\n
    if(org.apache.commons.lang3.StringUtils.isEmpty(keyValues)){
      return JsonResult.buildErrorStateResult("请输入查询条件",null);
    }

    List<UserQueryInfo> uqls=new ArrayList<UserQueryInfo>();

    String[] values=keyValues.split(";");

    List<String> queryV= Arrays.asList(values);

    if(queryV!=null&&queryV.size()>1000){
      return JsonResult.buildErrorStateResult("查询记录数是"+queryV.size()+",超过1000条限制",null);
    }


    //如果维度里面没有保护查询条件则加入条件
    if(!columns.contains(key)){
      columns=columns+","+key;
    }

    List<UserQueryInfo> userQueryInfos=new ArrayList<UserQueryInfo>();
    List<UserDetail> userDetails=new ArrayList<UserDetail>();
    List<Address> addresslist=new ArrayList<Address>();
    HashMap<String,String> phonesCards=new HashMap<String,String>();
    if(key.equals("userId")){
      List<Long> userIds=new ArrayList<Long>();
      try{
        for(String s:queryV){
          if(s.length()>8){
            return JsonResult.buildErrorStateResult("查询的userId"+s+"长度超过8位",s);
          }
          long uid=Long.valueOf(s);
          userIds.add(uid);
        }

      }catch(Exception e){
        return JsonResult.buildErrorStateResult("查询的userId有误",null);
      }

      userDetails=userDetailService.findByUserIdIn(userIds);
    }else if(key.equals("phoneNo")){
      for(String pn:queryV){
        if(!ValidationUtil.validatePhoneNo(pn)){
          return JsonResult.buildErrorStateResult("查询的手机号码"+pn+"格式有误",pn);
        }
      }

      userDetails=userDetailService.findByPhoneNos(queryV);
    }else if(key.equals("idNo")){
      IdcardValidator iv = new IdcardValidator();
      for(String idno:queryV){
        if(!iv.is18Idcard(idno)&&!iv.is15Idcard(idno)){
          return JsonResult.buildErrorStateResult("查询的身份证号"+idno+"格式有误",idno);
        }
      }
      userDetails=userDetailService.findByIdnos(queryV);
    }


    if(columns.contains("bankCard")){
      //需加银行卡信息
      if(key.equals("phoneNo")){
        phonesCards=getBankCardsByPhoneNos(queryV);
      }else{
        List<String> phones=new ArrayList<String>();
        for(UserDetail uda:userDetails){
          phones.add(uda.getPhoneNo());
        }
        phonesCards=getBankCardsByPhoneNos(phones);
      }
    }

    if(columns.contains("address")){
      List<Long> uidss=new ArrayList<Long>();
      //加地址信息
      for(UserDetail ud:userDetails){
        uidss.add(ud.getUserId());
      }
      if(uidss!=null&&uidss.size()>0){
        addresslist=addressService.findByUserIds(uidss);
      }

    }

    for(UserDetail ud:userDetails){
      UserQueryInfo uqi=new UserQueryInfo();
      if(columns.contains("idNo")){
        uqi.setIdNo(ud.getIdNo());
      }
      if(columns.contains("phoneNo")){
        uqi.setPhoneNo(ud.getPhoneNo());
      }
      if(columns.contains("userId")){
        uqi.setUserId(ud.getUserId());
      }
      if(columns.contains("address")){
        Optional<Address> oad=addresslist.stream().filter(addr->addr.getUserId()==ud.getUserId()).findFirst();
        if(oad.isPresent()){
          uqi.setAddress(oad.get().toString());
        }
      }
      if(columns.contains("bankCard")&&phonesCards!=null){
        uqi.setBankCards(phonesCards.get(ud.getPhoneNo()));
      }
      uqls.add(uqi);

    }

//    //不保存记录
//    UserQueryLog log=new UserQueryLog();
//    log.setQueryItems(columns.replace("userId","用户ID").replace("phoneNo","手机号").replace("idNo","身份证号").replace("bankCard","银行卡号").replace("address","地址"));
//    log.setResultAmount(Long.valueOf(userDetails.size()));
//    //转换存储
//    log.setQueryCondition(key.replace("userId","用户ID").replace("phoneNo","手机号").replace("idNo","身份证号"));
//    log.setQueryDetail(keyValues.replace("\n",";"));
//    log.setLoginUserName(userName);
//    userQueryLogService.save(log);

    HSSFWorkbook wb = new HSSFWorkbook();
    // 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
    HSSFSheet sheet = wb.createSheet("用户信息列表");
    // 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
    HSSFRow row = sheet.createRow((int) 0);
    // 第四步，创建单元格，并设置值表头 设置表头居中
    HSSFCellStyle style = wb.createCellStyle();
    style.setAlignment(HSSFCellStyle.ALIGN_CENTER); // 创建一个居中格式

    HSSFCell cell = row.createCell(0);
    cell.setCellValue("userId");
    cell.setCellStyle(style);
    cell = row.createCell( 1);
    cell.setCellValue("手机号");
    cell.setCellStyle(style);
    cell = row.createCell( 2);
    cell.setCellValue("身份证号");
    cell.setCellStyle(style);
    cell = row.createCell( 3);
    cell.setCellValue("银行卡号");
    cell.setCellStyle(style);

    cell = row.createCell( 4);
    cell.setCellValue("地址");
    cell.setCellStyle(style);

    // 第五步，写入实体数据 实际应用中这些数据从数据库得到，
    //List list = CreateSimpleExcelToDisk.getStudent();

    for (int i = 0; i < uqls.size(); i++)
    {
      row = sheet.createRow((int) i + 1);
      UserQueryInfo user = uqls.get(i);
      // 第四步，创建单元格，并设置值
      if(user!=null&&row!=null){
        HSSFCell cell0= row.createCell(0);
        if(cell0!=null){
          cell0.setCellValue(user.getUserId()==null?" ":String.valueOf(user.getUserId()));//user.getUserId()==null?" ":String.valueOf(user.getUserId())
        }

        HSSFCell cell1= row.createCell(1);
        if(cell1!=null){
          cell1.setCellValue(user.getPhoneNo()==null?" ":user.getPhoneNo());
        }

        HSSFCell cell2= row.createCell(2);
        if(cell2!=null){
          cell2.setCellValue(user.getIdNo()==null?" ":user.getIdNo());
        }

        HSSFCell cell3= row.createCell(3);
        if(cell3!=null){
          cell3.setCellValue(user.getBankCards()==null?" ":user.getBankCards());
        }

        HSSFCell cell4= row.createCell(4);
        if(cell4!=null){
          cell4.setCellValue(user.getAddress()==null?" ":user.getAddress());
        }

      }
    }
    // 第六步，将文件存到指定位置
    try
    {
      OutputStream output=response.getOutputStream();
      response.reset();
      response.setHeader("Content-disposition", "attachment; filename=users.xlsx");
      response.setContentType("application/vnd.ms-excel;charset=utf-8");
      response.setCharacterEncoding("utf-8");
      wb.write(output);
      output.close();

    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
    return JsonResult.buildSuccessResult("导出成功",null);
  }

  private String checkUserToken(String token){

    HashMap<String, String> parameters = new HashMap<>();
    parameters.put("token", token);
    //访问用户中心查询用户银行卡接口
    String resultStr = httpService.post(yunyingUrl + "/user/info", parameters);
    try{
      JsonObject resultUser = new JsonParser().parse(resultStr).getAsJsonObject();
      if(resultUser.get("code").getAsString().equals("0000")&&resultUser.get("data").getAsJsonObject()!=null){
        String userName=resultUser.get("data").getAsJsonObject().get("user").getAsString();
        return userName;
      }
    }catch(Exception e){
        LOGGER.info("解析运营系统用户token返回结果resultStr异常");
    }
    return "";
  }
}
