package cn.quantgroup.xyqb.util;

import java.util.Objects;
import org.springframework.security.crypto.bcrypt.BCrypt;

/**
 * Created by Miraculous on 15/7/5.
 */
public class BctyptPasswordUtil {
    public static void main(String[] args) {
        System.out.println(BCryptWithSalt("123456"));
        System.out.println(BCryptCheckPw("123456", BCryptWithSalt("123456")));
    }

    public final static String BCryptWithSalt(String password) {
        if(Objects.isNull(password)){
            return null;
        }
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public final static Boolean BCryptCheckPw(String password, String hashe) {
        return BCrypt.checkpw(password, hashe);
    }

}
