package cn.quantgroup.xyqb.controller.external.motan;

import cn.quantgroup.service.*;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.sql.Timestamp;
import java.text.ParseException;

/**
 * Created by 11 on 2017/2/27.
 */
@MotanService(export = "demoMotan:8002", registry="registryConfig")
public class MotanUserServiceImpl implements UserMotanService{

    private static final Logger LOGGER = LoggerFactory.getLogger(MotanUserServiceImpl.class);

    private static final ObjectMapper MAPPER = new ObjectMapper();
    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Autowired
    private IIdCardService idCardService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserDetailService userDetailService;

    @Override
    public UserSysResult<XUser> findUserByPhoneNo(String phoneNo) {
        User user = userService.findByPhoneInDb(phoneNo);
        XUser xUser = convertObject(JSON.toJSONString(user), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUser> findUserByUuid(String uuid) {
        User user = userService.findByUuidInDb(uuid);
        XUser xUser = convertObject(JSON.toJSONString(user), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUser> saveUser(UserBean userBean) {
        UserSysResult<XUser> result = new UserSysResult<>();
        if(null == userBean) {
            result.setCode("0001");
            result.setBusinessCode("0001");
            result.setMsg("要保存的用户对象不能为null");
            result.setData(null);
            return result;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        User user = new User();
        user.setCreatedAt(now);
        user.setUpdatedAt(now);
        user.setUuid(userBean.getUuid());
        user.setPhoneNo(userBean.getPhoneNo());
        user.setEnable(true);
        user.setPassword(userBean.getPassword());
        user.setRegisteredFrom(userBean.getRegisteredFrom());
        User saveUser = userService.saveUser(user);
        XUser xUser = convertObject(JSON.toJSONString(saveUser), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUserDetail> findUserDetailByUserId(Long userId) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        XUserDetail xUserDetail = convertObject(JSON.toJSONString(userDetail), new TypeReference<XUser>() {});
        return returnValue(xUserDetail, "");
    }

    @Override
    public UserSysResult<XUser> findUserByUserId(Long id) {
        User user = userService.findById(id);
        XUser xUser = convertObject(JSON.toJSONString(user), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUserDetail> findUserDetailByPhone(String phoneNo) {
        UserDetail userDetail = userDetailService.findByPhoneNo(phoneNo);
        XUserDetail xUserDetail = convertObject(JSON.toJSONString(userDetail), new TypeReference<XUserDetail>() {});
        return returnValue(xUserDetail, "");
    }

    @Override
    public UserSysResult<XUserDetail> saveUserDetail(UserDetailUpdateBean userDetailUpdateBean) {
        UserSysResult<XUserDetail> result = new UserSysResult<>();
        result.setCode("0001");
        result.setBusinessCode("0001");
        if(null == userDetailUpdateBean) {
            result.setMsg("要保存的用户详情对象不能为null");
            result.setData(null);
            return result;
        }
        UserDetail userDetail = new UserDetail();
        if(null != userDetailUpdateBean.getId() && userDetailUpdateBean.getId() > 0L) {
            userDetail.setId(userDetailUpdateBean.getId());
        }
        userDetail.setUserId(userDetailUpdateBean.getUserId());
        userDetail.setName(userDetailUpdateBean.getName());
        userDetail.setPhoneNo(userDetailUpdateBean.getPhoneNo());
        userDetail.setIdNo(userDetailUpdateBean.getIdNo());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        userDetail.setCreatedAt(time);
        userDetail.setUpdatedAt(time);
        userDetail.setIdType(IdType.ID_CARD);
        try {
            userDetail.setGender(idCardService.getIdCardInfo(userDetailUpdateBean.getIdNo()).getGender());
        } catch (ParseException e) {
            LOGGER.error("根据身份证获取性别出错,错误信息:" + e);
            result.setMsg("根据身份证获取性别出错.");
            return result;
        }
        userDetail.setEmail(userDetailUpdateBean.getEmail());
        userDetail = userDetailService.saveUserDetail(userDetail);
        if(userDetail != null){
            XUserDetail xUserDetail = convertObject(JSON.toJSONString(userDetail), new TypeReference<XUserDetail>() {});
            return returnValue(xUserDetail, "");
        }
        result.setMsg("");
        return result;
    }

    private <T> T convertObject(String json, TypeReference typeReference) {
        try {
            if(StringUtils.isEmpty(json)) {
                return null;
            }
            return MAPPER.readValue(json, typeReference);
        }catch (Exception ex) {
            LOGGER.error("用户信息转换出错,错误信息{}", ex);
            return null;
        }

    }

    /**
     * 封装返回结果.
     * @param t
     * @param message
     * @param <T>
     * @return
     */
    private <T> UserSysResult<T> returnValue(T t, String message) {
        UserSysResult<T> userSysResult = new UserSysResult();
        userSysResult.setMsg(message);
        /**
         * 无返回结果时,返回的code和BusinessCode均是0001
         */
        if(null == t) {
            userSysResult.setData(null);
            userSysResult.setBusinessCode("0001");
            userSysResult.setCode("0001");
        } else {
            userSysResult.setData(t);
            userSysResult.setBusinessCode("0000");
            userSysResult.setCode("0000");
        }
        return userSysResult;
    }
}
