package cn.quantgroup.xyqb.controller.req.v2;

import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.Gender;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import java.time.LocalDate;

/**
 * 用户扩展信息存储
 */
@Data
public class UserInfoEntityReq {

    //用户ID
    private Long userId;


    //0 未知 1 女 2 男
    private Gender gender;

    private String email;

    private String qq;

    //姓名预留字段，目前无场景使用
    private String name;

    //昵称
    private String nickName;

    //头像
    private String photo;

    //生日
    private String birthday;

    public static boolean checkParam(UserInfoEntityReq req) {
        if (req == null || req.getUserId() == null ||
                (StringUtils.isEmpty(req.getBirthday())
                        && StringUtils.isEmpty(req.getEmail())
                        && StringUtils.isEmpty(req.getQq())
                        && StringUtils.isEmpty(req.getName())
                        && StringUtils.isEmpty(req.getNickName())
                        && StringUtils.isEmpty(req.getPhoto())
                        && req.getGender() == null)) {

            return false;
        }
        return true;
    }

}
