package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Data
public class UserBean {
    private Long userId;
    private List<Wechat> wechatList;
    private UserAttachedInfo userAttachedInfo;
    private String phoneNo;

    private Long registeredFrom;

    private String uuid;

    private Boolean enable;
    private Integer tenantId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createdAt;

    @Builder
    @Getter
    public static class Wechat {
        private String openId;
        private String appId;
        private String unionId;
    }

    @Data
    public static class UserAttachedInfo{

        private Gender gender;

        private String email;

        private String qq;
        //真实姓名预留字段
        private String name;
        //昵称
        private String nickName;
        //头像
        private String photo;
        //生日
        private LocalDate birthday;
    }


    public static UserBean from(User user, List<WechatUserInfo> wechatUserInfoList,UserInfoEntity userInfoEntity) {
        UserBean userBean = new UserBean();
        userBean.setUserId(user.getId());
        userBean.setPhoneNo(user.getPhoneNo());
        userBean.setRegisteredFrom(user.getRegisteredFrom());
        userBean.setUuid(user.getUuid());
        userBean.setEnable(user.getEnable());
        userBean.setTenantId(user.getTenantId());
        userBean.setCreatedAt(user.getCreatedAt());
        if (CollectionUtils.isNotEmpty(wechatUserInfoList)) {
            List<Wechat> wcList = Lists.newArrayList();
            wechatUserInfoList.stream().forEach(wechatUserInfo->{
                Wechat build = Wechat.builder()
                        .openId(wechatUserInfo.getOpenId())
                        .unionId(wechatUserInfo.getUnionId())
                        .appId(wechatUserInfo.getAppId()).build();

                wcList.add(build);
            });
            userBean.setWechatList(wcList);
        }
        if (userInfoEntity != null) {
            UserAttachedInfo info = new UserAttachedInfo();
            BeanUtils.copyProperties(userInfoEntity,info);
            userBean.setUserAttachedInfo(info);
        }
        return userBean;
    }

    public static List<UserBean> from(List<User> userList, List<WechatUserInfo> wechatUserInfoList,List<UserInfoEntity> userInfoEntityList) {

        Map<Long, UserInfoEntity> userIdEntityMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(userInfoEntityList)) {
            userIdEntityMap = userInfoEntityList.stream().collect(Collectors.toMap(UserInfoEntity::getUserId, Function.identity(), (k1, k2) -> k1));
        }

        List<UserBean> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(userList)) {
            for (User user : userList) {

                UserBean userBean = new UserBean();
                userBean.setUserId(user.getId());
                userBean.setPhoneNo(user.getPhoneNo());
                userBean.setRegisteredFrom(user.getRegisteredFrom());
                userBean.setUuid(user.getUuid());
                userBean.setEnable(user.getEnable());
                userBean.setTenantId(user.getTenantId());
                userBean.setCreatedAt(user.getCreatedAt());

                UserInfoEntity userInfoEntity = userIdEntityMap.get(user.getId());
                if (userInfoEntity != null) {
                    UserAttachedInfo info = new UserAttachedInfo();
                    BeanUtils.copyProperties(userInfoEntity,info);
                    userBean.setUserAttachedInfo(info);
                }


                if (CollectionUtils.isNotEmpty(wechatUserInfoList)) {
                    Optional<WechatUserInfo> optionalWechatUserInfo = wechatUserInfoList.stream().filter(i -> i.getUserId() != null && i.getUserId().equals(user.getId())).findFirst();

                    if (optionalWechatUserInfo.isPresent()) {
                        WechatUserInfo wechatUserInfo = optionalWechatUserInfo.get();
                        userBean.setWechatList(Collections.singletonList(Wechat.builder()
                                .openId(wechatUserInfo.getOpenId())
                                .unionId(wechatUserInfo.getUnionId())
                                .appId(wechatUserInfo.getAppId()).build()));
                    }
                }

                result.add(userBean);
            }
        }
        return result;
    }
}
