package cn.quantgroup.xyqb.event.jr58;

import cn.quantgroup.xyqb.service.http.IHttpService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class Jr58DataSender {

    private static final Logger LOGGER = LoggerFactory.getLogger(Jr58DataSender.class);

    @Autowired
    private Jr58MessageSigner jr58MessageSigner;

    @Autowired
    private IHttpService httpService;

    @Value("${jr58.notify.userinfo}")
    private String jr58nNotifyUserinfo;

    /**
     * 向58金融同步用户信息
     *
     * @param uuid
     */
    @Async
    public void sendUserinfo(String uuid) {
        try {
            JSONObject json = new JSONObject();
            json.put("salaryWay", 0);
            json.put("loanPurpose", "12");
            json.put("job", 0);
            json.put("account", 1000);
            json.put("salary", 0);
            json.put("hourse", 1);
            json.put("isShebao", 0);
            json.put("education", "");
            json.put("isCreditCard", "0");
            json.put("isOtherLoanOrg", "0");

            String userinfo = json.toString();
            String param = uuid + "|1|" + userinfo;
            String sign = jr58MessageSigner.sign(param);

            Map<String, String> parameters = ImmutableMap.<String, String>builder()
                    .put("customerId", uuid)
                    .put("authorState", "100")
                    .put("baseFlag", "1")
                    .put("userinfo", userinfo)
                    .put("sign", sign)
                    .build();

            httpService.post(jr58nNotifyUserinfo, parameters);

        } catch (Exception e) {
            LOGGER.error("向58金融同步用户信息", e);
        }
    }
}
