package cn.quantgroup.xyqb.aspect.captcha;


import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.JsonResult;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * 密码错误限次的校验
 * @author 任文超
 * @version 1.0.0
 * @since 2017-11-23
 */
@Aspect
@Component
public class PasswordErrorFiniteValidateAdvisor {

  private static final Logger LOGGER = LoggerFactory.getLogger(PasswordErrorFiniteValidateAdvisor.class);

  @Autowired
  @Qualifier("stringRedisTemplate")
  private RedisTemplate<String, String> redisTemplate;

  /**
   * 密码错误限次切面
   */
  @Pointcut("@annotation(cn.quantgroup.xyqb.aspect.captcha.PasswordFineteValidator)")
  private void passwordErrorFiniteValidate() {
  }

  /**
   * 在受保护的接口方法执行前, 执行锁状态校验
   *
   * @param pjp
   * @return
   * @throws Throwable
   */
  @Around("passwordErrorFiniteValidate()")
  private Object doFiniteValidate(ProceedingJoinPoint pjp) throws Throwable {
    /*if(!ValidationUtil.isAtDangerousTime()){
      return pjp.proceed();
    }*/
    HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    // 客户端IP
    String clientIp = getIp(request);
    if (StringUtils.startsWith(clientIp, "139.198.")){
      return pjp.proceed();
    }
    String lockIpv4Key = getLockIpv4Key(clientIp);
    String lock = redisTemplate.opsForValue().get(lockIpv4Key);
    if (Objects.equals(Boolean.TRUE.toString(), lock)){
      LOGGER.info("Locked ip access:{}", clientIp);
      return JsonResult.buildErrorStateResult("登录失败", null);
    }
    return pjp.proceed();
  }

  private final static String getLockIpv4Key(String ipv4){
    return Constants.IPV4_LOCK + ipv4;
  }

  /**
   * 客户端IP解析
   *
   * @param request 当前请求，其首部行必须包含形如【SingleToken 13461067662:0123456789abcdef】的UTF-8编码的Base64加密参数
   * @return 客户端IP 或 null
   */
  private String getIp(HttpServletRequest request) {
    Objects.requireNonNull(request, "无效请求");
    String ip = request.getHeader("x-real-ip");
    if (StringUtils.isBlank(ip)) {
      ip = request.getRemoteAddr();
    }
    //过滤反向代理的ip
    String[] stemps = ip.split(",");
    if (stemps.length >= 1) {
      //得到第一个IP，即客户端真实IP
      ip = stemps[0];
    }
    ip = ip.trim();
    if (ip.length() > 23) {
      ip = ip.substring(0, 23);
    }
    return ip;
  }


}
