package common;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import java.sql.Timestamp;

@Slf4j
@RunWith(JUnit4.class)
public class JsonTest {
  private static final Gson GSON = new Gson();
  private static final ObjectMapper MAPPER = new ObjectMapper()
          .configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
          .configure(SerializationFeature.WRITE_ENUMS_USING_INDEX, true)
          .configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
  private static final String body = "{\"id\":795,\"userId\":878,\"phoneNo\":\"18810882232\",\"name\":\"马怔\",\"idNo\":\"534255196412036829\",\"idType\":\"ID_CARD\",\"isAuthenticated\":false,\"gender\":\"FEMALE\",\"email\":\"83929382938@qq.com\",\"qq\":\"\",\"createdAt\":1529463464000}";

  @Test
  public void intFloat(){
    try {
      UserDetail userData = new UserDetail();
      userData.setId(131L);
      userData.setUserId(119L);
      userData.setCreatedAt(new Timestamp(1));
      log.info("序列化--GSON--成功！data:{}", GSON.toJson(userData));
      log.info("序列化--MAPPER--成功！data:{}", MAPPER.writeValueAsString(userData));
      log.info("序列化--JSON--成功！data:{}", JSON.toJSONString(userData, SerializerFeature.config(JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.WriteEnumUsingName, false)));
      log.info("序列化--JSONObject--成功！data:{}", JSONObject.toJSONString(userData));
    }catch (Exception e){
      log.error("序列化--GSON--失败！", e);
    }
  }

  @Test
  public void gsonGson(){
    try {
      UserDetail userData = GSON.fromJson(body, UserDetail.class);
      log.info("GSON--成功！data:{}", userData);
    }catch (Exception e){
      log.error("GSON--失败！", e);
    }
  }

  @Test
  public void jacksonObjectMapper(){
    try {
      UserDetail userData = MAPPER.readValue(body, UserDetail.class);
      log.info("MAPPER--成功！data:{}", userData);
    }catch (Exception e){
      log.error("MAPPER--失败！", e);
    }
  }

  @Test
  public void fastjsonJSONObject(){
    try {
      UserDetail userData = JSONObject.parseObject(body, UserDetail.class);
      log.info("JSONObject--成功！data:{}", userData);
      userData = JSON.parseObject(body, UserDetail.class);
      log.info("JSONObject--成功！data:{}", userData);
    }catch (Exception e){
      log.error("JSONObject--失败！", e);
    }
  }

  @Test
  public void test() throws Exception{
    String extData = "eyJyZWRpcmVjdCI6ImxvY2FsIiwicmVnaXN0ZXJGcm9tIjoyMjJ9";
    System.out.println(new String(Base64.decodeBase64(extData), "UTF-8"));
  }

}
