package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserDetail;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author mengfan.feng
 * @time 2015-09-11 11:22
 */
public interface IUserDetailRepository extends JpaRepository<UserDetail, Long>, JpaSpecificationExecutor<UserDetail> {

    UserDetail findByUserId(Long userId);

    UserDetail findByPhoneNo(String phone);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_detail set qq = ?1 where user_id = ?2", nativeQuery = true)
    void updateUserQq(String qq, Long userId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_detail set email = ?1 where user_id = ?2", nativeQuery = true)
    void updateUserEmail(String email, Long userId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_detail set gender = ?1 where user_id = ?2", nativeQuery = true)
    void updateGender(int gender, Long userId);

    List<UserDetail> findAll(Specification<UserDetail> specification);


    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_detail set name=?1,gender=?2 where phone_no=?3", nativeQuery = true)
    int updateNameAndIdNoByPhoneNo(String name,int gender, String phoneNo);

    /**
     * 按照身份证号和手机号 - 模糊查询
     *
     * @param phoneNo - 手机号
     * @return List<UserDetail>
     */
    @Query(value = "select * from user_detail where phone_no like ?1", nativeQuery = true)
    List<UserDetail> fuzzyQueryByPhoneNo(String phoneNo);

    List<UserDetail> findTop20ByPhoneNoStartingWith(String phoneNo);


    UserDetail findByUserIdAndPhoneNoAndName(Long userId, String phoneNo, String name);
}
