package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 用户注册发送给合同中心事件监听
 */
@Slf4j
@Component
public class BlackHoleRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Value("${registered.notify.black.hole.rabbitmq.connection.exchange}")
    private String exchange;
    @Value("${registered.notify.black.hole.rabbitmq.connection.routingKey}")
    private String routingKey;
    @Resource
    private RabbitTemplate registeredNotifyBlackHoleRabbitTemplate;

    // 用户注册合同中心模版id
    @Value("#{'${register.templateids}'.split(',')}")
    private List<Long> templateIds;

    @Resource
    private IUserService userService;


    @Override
    public void onApplicationEvent(RegisterEvent event) {
        User user = event.getUserRegisterParam().getUser();
        log.info("onApplicationEvent start userId = 【{}】， registerFrom = 【{}】", user.getId(), event);
        LocalDate signDate = LocalDate.now();
        String dateStr = signDate.format(DateTimeFormatter.ofPattern("yyyy年MM月dd日"));
        int day = signDate.getDayOfMonth();
        // 信用钱包服务与隐私协议
        templateIds.forEach(id -> {
            JSONObject fields = new JSONObject();
            fields.put("phoneNo", user.getPhoneNo());
            fields.put("genarateDateStr", dateStr);
            fields.put("day", day);
            JSONObject json = new JSONObject();
            json.put("userId", user.getId());
            json.put("mustReal", false);
            json.put("templateId", id);
            json.put("fields", fields);
            JSONArray array = new JSONArray();
            array.add(json);
            registeredNotifyBlackHoleRabbitTemplate.convertAndSend(exchange, routingKey,
                array.toString());
        });
        // 不同渠道签署不同的合同模板
        userService.channelUserSignContract(user, null);
    }
}
