package cn.quantgroup.xyqb.service.mq.Impl;

import cn.quantgroup.xyqb.model.UserRegisterMqMessage;
import cn.quantgroup.xyqb.service.mq.IRegisterMqService;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * Created by xuran on 2017/9/7.
 */
@Service("registerMqService")
public class IRegisterMqServiceImpl implements IRegisterMqService {
  private static final Logger LOGGER = LoggerFactory.getLogger(IRegisterMqServiceImpl.class);

  @Autowired
  @Qualifier("registerRabbitTemplate")
  RabbitTemplate registerRabTemplate;

  @Autowired
  @Qualifier(value = "registerMqQueue")
  Queue registerMqQueue;








  /**
   * 发送用登陆统计信息
   * @param message 订单信息
   */
  @Async
  public void send(UserRegisterMqMessage message){
    if(null==message){
      LOGGER.error("广播用户注册消息不能为空");
    }

    LOGGER.info("广播用户注册消息,message={}",message);
    String msg  = JSONObject.toJSONString(message);
    registerRabTemplate.convertAndSend(msg);

    LOGGER.info("广播用户注册消息,message={}",msg);
  }


}
