package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.Address;
import lombok.Data;

/**
 * Created by Miraculous on 2017/2/14.
 */
@Data
public class AddressRet {
    private static final long serialVersionUID = -1L;

    private Long id;
    private Long userId;
    private Long provinceCode;
    private String province;
    private Long cityCode;
    private String city;
    private Long districtCode;
    private String district;
    private String address;
    private Long createdAt;
    private Long updateAt;

    public static AddressRet address2AddressRet(Address address) {
        if (address == null) {
            return null;
        }
        AddressRet ret = new AddressRet();
        ret.setId(address.getId());
        ret.setUserId(address.getUserId());
        ret.setProvinceCode(address.getProvinceCode());
        ret.setCityCode(address.getCityCode());
        ret.setDistrictCode(address.getDistrictCode());
        ret.setDistrict(address.getDistrict());
        ret.setProvince(address.getProvince());
        ret.setCity(address.getCity());
        ret.setAddress(address.getAddress());
        ret.setCreatedAt(address.getCreatedAt().getTime());
        ret.setUpdateAt(address.getUpdateAt().getTime());
        return ret;
    }
}
