package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.repository.IUserHashMappingRepository;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;


/**
 * userDetail 更新时, 保存 hashMapping 数据
 */
@Component
@Slf4j
public class UserDetailHashEventListener implements ApplicationListener<UserDetailUpdateEvent> {

    @Autowired
    private IUserHashMappingRepository userHashMappingRepository;


    @Override
    public void onApplicationEvent(UserDetailUpdateEvent event) {
        UserDetail userDetail = event.getUserDetail();

        UserHashMapping userHashMapping = userHashMappingRepository.findByUserId(userDetail.getUserId());

        //如果不存在, 我先保存一下
        if (userHashMapping == null) {
            userHashMapping = new UserHashMapping(userDetail.getUserId());
            String phoneNo = userDetail.getPhoneNo();
            userHashMapping.setPhoneNoMd5(MD5Util.build(phoneNo));
        }

        String idNoMd5 = userHashMapping.getIdNoMd5();

        String idNo = userDetail.getIdNo().toUpperCase();

        String idNoMd5New = MD5Util.build(idNo);

        //新旧相同, 直接跳过
        if (StringUtils.equals(idNoMd5, idNoMd5New)) {
            return;
        }

        userHashMapping.setIdNoMd5(idNoMd5New);
        try {
            userHashMappingRepository.save(userHashMapping);
        } catch (ConstraintViolationException e) {
            log.error("保存userHashMapping重复, 无需再保存, userId:{}", userDetail.getUserId());
        }

    }
}
