package service;

import cn.quantgroup.xyqb.Bootstrap;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import lombok.extern.slf4j.Slf4j;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by xuran on 2017/12/26.
 */
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
@SpringBootTest(classes = Bootstrap.class )
@Slf4j
@Rollback
@Transactional(rollbackFor = Exception.class)
@RunWith(Parameterized.class)
public class UserServiceTest {
    private TestContextManager testContextManager;




    public UserServiceTest() {
        super();
    }
    @Before
    public void setUpContext() throws Exception {
        //this is where the magic happens, we actually do "by hand" what the spring runner would do for us,
        // read the JavaDoc for the class bellow to know exactly what it does, the method names are quite accurate though
        this.testContextManager = new TestContextManager(getClass());
        this.testContextManager.prepareTestInstance(this);
    }


}
