package cn.quantgroup.xyqb.entity;

import cn.quantgroup.motan.retbean.XUserDetail;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Optional;

/**
 * Created by FrankChow on 15/7/8.
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user_detail", uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
public class UserDetail implements Serializable {

  private static final long serialVersionUID = -1L;

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  @Column(name = "user_id")
  private Long userId;

  @Column(name = "phone_no")
  private String phoneNo;

  @Column(name = "name")
  private String name;

  //证件号
  @Column(name = "id_no")
  private String idNo;

  //0 身份证 1 军官证 2 护照
  @Column(name = "id_type")
  private IdType idType;

  //身份证验真 0 未认证 1认证
  @Column(name = "is_authenticated")
  private Boolean isAuthenticated = false;

  //0 未知 1 女 2 男
  @Column(name = "gender")
  private Gender gender;

  @Column(name = "email")
  private String email;

  @Column(name = "qq")
  private String qq;

  //创建时间
  @Column(name = "created_at")
  private Timestamp createdAt;

  //上一次修改时间
  @Column(name = "updated_at")
  private Timestamp updatedAt;

  public XUserDetail toXUserDetail() {
    XUserDetail xUserDetail = new XUserDetail();
    xUserDetail.setId(this.getId());
    xUserDetail.setUserId(this.getUserId());
    xUserDetail.setPhoneNo(this.getPhoneNo());
    xUserDetail.setName(this.getName());
    xUserDetail.setIdNo(this.getIdNo());
    if (this.getIdType() != null) {
      xUserDetail.setIdType(cn.quantgroup.motan.enums.IdType.valueOf(this.getIdType().name()));
    }
    if (this.getGender() != null) {
      xUserDetail.setGender(cn.quantgroup.motan.enums.Gender.valueOf(Optional.ofNullable(this.getGender()).orElse(Gender.UNKNOWN).name()));
    }
    xUserDetail.setEmail(this.getEmail());
    xUserDetail.setQq(this.getQq());
    xUserDetail.setId(this.getId());
    xUserDetail.setCreatedAt(this.getCreatedAt());
    xUserDetail.setUpdatedAt(this.getUpdatedAt());
    xUserDetail.setIsAuthenticated(this.getIsAuthenticated());
    return xUserDetail;
  }


}
