package cn.quantgroup.xyqb.service.page.impl;

import cn.quantgroup.xyqb.entity.*;
import cn.quantgroup.xyqb.model.Tuple;
import cn.quantgroup.xyqb.repository.IUserExtInfoRepository;
import cn.quantgroup.xyqb.service.page.IPageService;
import cn.quantgroup.xyqb.service.page.bean.PageType;
import cn.quantgroup.xyqb.service.user.IAddressService;
import cn.quantgroup.xyqb.service.user.IContactService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserExtInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Service
public class PageServiceImpl implements IPageService {

    private Map<String, PageType[]> routerDefinetion;
    private PageType pageIdNo = new PageType("name", false) {
        @Override
        public boolean canPass(User user) {
            UserDetail userDetail = userDetailService.findByUserId(user.getId());
            return userDetail != null;
        }
    };
    private PageType pageUserFinance = new PageType("info", false) {
        @Override
        public boolean canPass(User user) {
            UserExtInfo extInfo = userExtInfoService.findByUserId(user.getId());
            return null != extInfo;
        }
    };
    private PageType pageAddress = new PageType("address", false) {
        @Override
        public boolean canPass(User user) {
            Address address = addressService.findByUserId(user.getId());
            return null != address;
        }
    };
    private PageType pageContacts = new PageType("contacts", false) {
        @Override
        public boolean canPass(User user) {
            List<Contact> contacts = contactService.findByUserId(user.getId());
            return contacts != null && contacts.size() != 0;
        }
    };
    @Autowired
    private IUserDetailService userDetailService;
    @Autowired
    private IUserExtInfoService userExtInfoService;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private IContactService contactService;

    @PostConstruct
    private void init() {
        routerDefinetion = new HashMap<>();

        routerDefinetion.put("cashTarget1", new PageType[] {
                pageIdNo, pageUserFinance
        });
        routerDefinetion.put("cashTarget2", new PageType[] {
                pageIdNo, pageAddress
        });
        routerDefinetion.put("cashTarget3", new PageType[] {
                pageIdNo, pageContacts
        });
        routerDefinetion.put("cashTarget4", new PageType[] {
                pageIdNo
        });
    }

    @Override
    public Tuple<String, Boolean> nextPage(User user, String target, String currentPage) {
        if (user == null ) {
            return new Tuple<>("", false);
        }
        PageType[] processLists = routerDefinetion.containsKey(target) ? routerDefinetion.get(target): null;
        if (processLists == null) {
            return new Tuple<>("", false);
        }
        boolean isBeforeCurrentPage = true;
        for (PageType page : processLists) {
            if (!page.canPass(user)) {
                return new Tuple<>(page.getName(), false);
            }
            if (!isBeforeCurrentPage && page.getNeedShow()) {
                return new Tuple<>(page.getName(), false);
            }
            if (page.getName().equals(currentPage)) {
                isBeforeCurrentPage = false;
            }
        }
        return new Tuple<>("", true);
    }

}
