package cn.quantgroup.xyqb.interceptors;

import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;

/**
 * Created by Administrator on 2017/5/9.
 */
public class IPWhiteListInterceptor implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPWhiteListInterceptor.class);

    private static final String [] allowIPs = {"139.198.7.123"};
    private static Set<String> allowIPSet = Sets.newHashSet(allowIPs);
    private Integer isDebug;

    public IPWhiteListInterceptor(Integer isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if(isDebug !=0){
            return true;
        }
        String remoteIP = IPUtil.getRemoteIP(request);
        if(IPUtil.whiteOf(remoteIP) || ValidationUtil.validateLocalIpv4(remoteIP) || allowIPSet.contains(remoteIP)) {
            return true;
        }
        LOGGER.info("非法IP尝试访问,ip:[{}]",remoteIP);
        return false;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {

    }
}
