package cn.quantgroup.xyqb.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by Miraculous on 2017/1/6.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LoginProperties {
    /**
     * 维度
     * 形如:"app|app名称|平台|应用市场名字"
     * 示例："dimension":"app|shandiandai|IOS|sdd-Appstore"
     */
    private String dimension;
    /**
     * 1-登录
     * 2-注册
     * 3-快捷登录
     * 4-免密登录
     */
    private int action;
    /**
     * 注册渠道号
     */
    private Long channelId = 1L;
    private Long createdFrom = 1L;
    private String appChannel = "";
    private Long merchantId = 1L;
    private String merchantName = "";
}
