package cn.quantgroup.xyqb.controller.middleoffice.common.image;

import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import java.util.HashMap;
import java.util.Map;

public class ImageVerifyStrategyFactory {
    private static final Map<ImageVerifyTypeEnum, IImageVerifyStrategy> strategiesMap = new HashMap<>();

    static {
        //cache
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        Map<String, IImageVerifyStrategy> beansOfType = context.getBeansOfType(IImageVerifyStrategy.class);
        beansOfType.values().forEach(strategy -> strategiesMap.put(strategy.strategyName(), strategy));
    }

    public static IImageVerifyStrategy get(ImageVerifyTypeEnum verifyTypeEnum) {
        return strategiesMap.get(verifyTypeEnum);
    }


}
