package cn.quantgroup.xyqb.controller.middleoffice.userext;


import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.*;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户扩展信息
 */
@RestController
@RequestMapping("/middle_office/user/ext")
public class UserExtController {

    @Resource
    private IUserExtInfoService userExtInfoService;

    @Resource
    private IContactService contactService;

    @Resource
    private IUserDetailService userDetailService;

    @Resource
    private IAddressService addressService;

    @Resource
    private IUserService userService;

    //todo 保存失败的各种场景。
    @PutMapping("/{userId}")
    public JsonResult ext(@PathVariable Long userId, List<Contact> contacts,
                          Address address, UserExtInfo userExtInfo, String email, String qq) {
        if (email != null) {
            userDetailService.updateUserEmail(userId, email);
        }
        if (qq != null) {
            userDetailService.updateUserQq(userId, qq);
        }
        if (CollectionUtils.isNotEmpty(contacts)) {
            contactService.save(userId, contacts);
        }
        if (address != null) {
            address.setUserId(userId);
            addressService.save(address);
        }
        if (userExtInfo != null) {
            userExtInfo.setUserId(userId);
            userExtInfoService.save(userExtInfo);
        }
        return JsonResult.buildSuccessResult();
    }

    @GetMapping("/userId/{userId}")
    public JsonResult query(@PathVariable Long userId,
                            @RequestParam(defaultValue = "false") Boolean address,
                            @RequestParam(defaultValue = "false") Boolean contacts,
                            @RequestParam(defaultValue = "false") Boolean extInfo) {
        Map<String, Object> result = new HashMap<>();
        if (address) {
            result.put("address", addressService.findByUserId(userId));
        }
        if (contacts) {
            result.put("contacts", contactService.findByUserId(userId, true));
        }
        if (extInfo) {
            result.put("extInfo", userExtInfoService.findByUserId(userId));
        }
        return JsonResult.buildSuccessResultGeneric(result);
    }

    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult query(@PathVariable String phoneNo,
                            @RequestParam(defaultValue = "false") Boolean address,
                            @RequestParam(defaultValue = "false") Boolean contacts,
                            @RequestParam(defaultValue = "false") Boolean extInfo) {
        User user = userService.findByPhoneWithCache(phoneNo);
        if (user == null) {
            return JsonResult.buildSuccessResult();
        }
        Long userId = user.getId();

        //todo duplicated
        Map<String, Object> result = new HashMap<>();
        if (address) {
            result.put("address", addressService.findByUserId(userId));
        }
        if (contacts) {
            result.put("contacts", contactService.findByUserId(userId, true));
        }
        if (extInfo) {
            result.put("extInfo", userExtInfoService.findByUserId(userId));
        }

        return JsonResult.buildSuccessResultGeneric(result);
    }

}
