package cn.quantgroup.xyqb.config.captcha;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.SimpleCaptcha;
import com.octo.captcha.Captcha;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaStore;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

/**
 * 类名称：RedisCaptchaStore
 * 类描述：
 *
 * @author 李宁
 * @version 1.0.0
 * 创建时间：15/12/17 06:39
 * 修改人：
 * 修改时间：15/12/17 06:39
 * 修改备注：
 */
@Slf4j
public class RedisCaptchaStore implements CaptchaStore {

    private static final long DEFAULT_EXPIRED_IN = 120L;
    private static final TimeUnit DEFAULT_EXPIRED_TIMEUNIT = TimeUnit.SECONDS;

    protected RedisTemplate<String, String> stringRedisTemplate;

    public RedisCaptchaStore(RedisTemplate<String, String> stringRedisTemplate) {
        super();
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public boolean hasCaptcha(String captchaId) {
        return stringRedisTemplate.hasKey(buildCaptcharKey(captchaId));
    }

    @Override
    public void storeCaptcha(String s, Captcha captcha) throws CaptchaServiceException {
        stringRedisTemplate.opsForValue().set(buildCaptcharKey(s), ((SimpleCaptcha) captcha).getResponse(), DEFAULT_EXPIRED_IN, DEFAULT_EXPIRED_TIMEUNIT);
    }

    @Override
    public void storeCaptcha(String s, Captcha captcha, Locale locale) throws CaptchaServiceException {
        stringRedisTemplate.opsForValue().set(buildCaptcharKey(s), ((SimpleCaptcha) captcha).getResponse(), DEFAULT_EXPIRED_IN, DEFAULT_EXPIRED_TIMEUNIT);
    }

    @Override
    public boolean removeCaptcha(String captchaId) {
        stringRedisTemplate.delete(buildCaptcharKey(captchaId));
        return true;
    }

    @Override
    public Captcha getCaptcha(String captchaId) throws CaptchaServiceException {
        return getFromRedisThenDel(captchaId);
    }

    @Override
    public Locale getLocale(String captchaId) throws CaptchaServiceException {
        return Locale.CHINA;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public Collection getKeys() {
        return Collections.emptyList();
    }

    @Override
    public void empty() {

    }

    @Override
    public void initAndStart() {

    }

    @Override
    public void cleanAndShutdown() {

    }

    private Captcha getFromRedis(String captchaId) {
        Object value = stringRedisTemplate.opsForValue().get(buildCaptcharKey(captchaId));
        return value != null ? new SimpleCaptcha(captchaId, String.valueOf(value)) : null;
    }

    private Captcha getFromRedisThenDel(String captchaId) {
        String captcharKey = buildCaptcharKey(captchaId);
        Long expire = stringRedisTemplate.getExpire(captcharKey, TimeUnit.SECONDS);
        Object value = stringRedisTemplate.opsForValue().get(captcharKey);
        log.info("captchaId={},captchaCode={},expire={}秒", captcharKey, value, expire);
        stringRedisTemplate.delete(captcharKey);
        return value != null ? new SimpleCaptcha(captchaId, String.valueOf(value)) : null;
    }

    protected String buildCaptcharKey(String captchaId) {
        return Constants.REDIS_CAPTCHA_KEY + captchaId;
    }

}
