package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.util.EmojiUtil;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2017/1/17.
 * 微信关联的用户信息
 */
@Entity
@Table(name = "wechat_userinfo")
@Data
public class WechatUserInfo implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    @Column(name = "user_id")
    private Long userId;
    @Column(name = "open_id")
    private String openId;
    @Column(name = "phone_no")
    private String phoneNo = "";
    @Column(name = "nick_name")
    private String nickName;
    @Column(name = "sex")
    private short sex;
    @Column(name = "language")
    private String language;
    @Column(name = "city")
    private String city;
    @Column(name = "province")
    private String province;
    @Column(name = "country")
    private String country;
    @Column(name = "head_img_url")
    private String headImgUrl;
    @Column(name = "created_at")
    private Timestamp createdAt = new Timestamp(System.currentTimeMillis());
    @Column(name = "updated_at")
    private Timestamp updatedAt = new Timestamp(System.currentTimeMillis());


    public WechatUserInfo convertEmoji() {
        WechatUserInfo wechatUserInfo = new WechatUserInfo();
        BeanUtils.copyProperties(this, wechatUserInfo);
        wechatUserInfo.setNickName(EmojiUtil.filterUnicode4(this.getNickName()));
        wechatUserInfo.setProvince(EmojiUtil.filterUnicode4(this.getProvince()));
        wechatUserInfo.setCity(EmojiUtil.filterUnicode4(this.getCity()));
        wechatUserInfo.setCountry(EmojiUtil.filterUnicode4(this.getCountry()));
        return wechatUserInfo;
    }

}
