package cn.quantgroup.xyqb.controller.external;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@Slf4j
@RestController
@RequestMapping("/ex/sync_hash")
public class SyncHashController {


    private Boolean isContinue = false;
    public static Boolean fight = false;
    @Autowired
    private IUserRepository userRepository;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    /**
     * 发起同步
     *
     * @param startUserId
     * @param step
     * @return
     */
    @GetMapping("/start")
    public JsonResult sync(final Long startUserId, final Long step) {
        isContinue = true;
        executorService
                .execute(() -> {
                    Long startPosition = startUserId;
                    while (isContinue) {
                        Stopwatch started = Stopwatch.createStarted();
                        Long endPosition = startPosition + step;
                        List<User> users = userRepository.findByIdBetween(startPosition, endPosition);
                        if (users.isEmpty()) {
                            log.info("没有数据了. 结束了");
                            return;
                        }
                        log.info("查询用户需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));
                        started = started.reset().start();
                        List<UserHashMapping> userHashMappings = new ArrayList<>();
                        users.forEach(user -> {
                            UserHashMapping userHashMapping = new UserHashMapping();
                            userHashMapping.setUserId(user.getId());
                            userHashMapping.setPhoneNoMd5(MD5Util.build(user.getPhoneNo()));
                            userHashMappings.add(userHashMapping);
                        });
                        log.info("遍历计算md5&crc32需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));
                        started = started.reset().start();
                        String sql = "INSERT INTO `user_hash_mapping` ( `user_id`, `phone_no_md5`, `phone_no_md5_short`) VALUES (?,?,?);";
                        jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
                            @Override
                            public void setValues(PreparedStatement ps, int i) throws SQLException {
                                UserHashMapping userHashMapping = userHashMappings.get(i);
                                ps.setLong(1, userHashMapping.getUserId());
                                ps.setString(2, userHashMapping.getPhoneNoMd5());
                                ps.setLong(3, userHashMapping.getPhoneNoMd5Short());
                            }

                            @Override
                            public int getBatchSize() {
                                return userHashMappings.size();
                            }
                        });

                        log.info("batchUpdate需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));

                        log.info("来一波,start:{},end:{}", startPosition, endPosition);
                        startPosition = users.get(users.size() - 1).getId() + 1;


                        try {
                            Thread.sleep(250);
                        } catch (InterruptedException e) {
                        }
                    }
                });

        return JsonResult.buildSuccessResult(null);
    }

    /**
     * 暂停同步
     */
    @GetMapping("/stop")
    public JsonResult stop() {
        isContinue = false;
        return JsonResult.buildSuccessResult(null);
    }

    @GetMapping("/fight")
    public JsonResult fight() {
        fight = true;
        return JsonResult.buildSuccessResult(null);
    }
}
