package cn.quantgroup.xyqb.config.thread;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;


/**
 * Created by xuran on 2017/11/8.
 */
@Configuration
@EnableAsync
public class AsyncConfig {

    /**
     * 生成线程池
     *
     * @param corePoolSize
     * @param maxPoolSize
     * @param queueCapacity
     * @param waitForCompleteOnShutdown
     * @param prefix
     * @return
     */
    private ThreadPoolTaskExecutor generateThreadPoolTaskExecutor(int corePoolSize, int maxPoolSize, int queueCapacity,
                                                                  boolean waitForCompleteOnShutdown, int keepAliveSeconds,
                                                                  boolean allowCoreThreadTimeOut, String prefix) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setKeepAliveSeconds(keepAliveSeconds);
        executor.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        executor.setWaitForTasksToCompleteOnShutdown(waitForCompleteOnShutdown);
        executor.setThreadNamePrefix(prefix);
        executor.initialize();
        return executor;
    }

    /**
     * 日志线程池
     *
     * @return
     */
    @Bean(name = "logExecutor")
    public Executor loanMqExecutor() {
        return generateThreadPoolTaskExecutor(100, 2000, 2000, true, 30, true, "loanMqExecutor-");
    }
}
