
        Merchant merchant = merchantService.findMerchantByName(systemKey);
        AccessTokenResponse token = wechatService.getToken(code);
        if (token == null) {
          // 让用户登录，不关联微信, 构造不关联微信的url
          redirectNormalUrl(response, merchant, registerFrom,protocol);
          return;
        }
        WechatUserInfo userInfo =
            wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(),
                token.getOpenId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
          // 让用户登录，不关联微信, 构造不关联微信的url
          redirectNormalUrl(response, merchant, registerFrom,protocol);
          return;
        }
        WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
        // welcome 首次登录
        if (userInfoInDb == null) {
          // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
          if (StringUtils.isNotBlank(userInfo.getNickName())) {
            String nickName = EmojiUtil.filter(userInfo.getNickName());
            userInfo.setNickName(nickName);
          }
          userInfo = wechatService.saveWechatUserInfo(userInfo);
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo, registerFrom,protocol);
          return;
        }
        if (userInfoInDb.getUserId() == null) {
          // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, registerFrom,protocol);
          return;
        }
        User user = userService.findById(userInfoInDb.getUserId());
        if (user == null) {
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, registerFrom,protocol);
          return;
        }
        // 已经关联了用户
        // create session, 登进去，该怎么玩怎么玩。
        String redirectUrl = createUserSession(user, merchant, redirect, schema, registerFrom);
        LOGGER.info("Location:[{}]",redirectUrl);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);