package cn.quantgroup.xyqb.config.data;

import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.WechatConfigBean;
import com.alibaba.fastjson.JSONArray;
import com.ctrip.framework.apollo.ConfigService;
import lombok.Getter;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;

@Component
@Getter
public class WechatConfiguration {

    private final List<WechatConfigBean> list;


    public WechatConfiguration() {
        String data = ConfigService.getAppConfig().getProperty("wechat.configs", "[]");
        list = JSONArray.parseArray(data, WechatConfigBean.class);
    }

    public WechatConfigBean getByAppIdAndTenantId(String appId, Integer tenantId){
        Optional<WechatConfigBean>  optional = list.stream().filter(i->i.getAppId().equals(appId)&&i.getTenantId().equals(tenantId)).findFirst();
        if(!optional.isPresent()){
            throw new BizException(BizExceptionEnum.ERROR_WECHAT_APP_ID);
        }else{
            return optional.get();
        }
    }

    public WechatConfigBean getDefault(){
        return list.stream().filter(WechatConfigBean::isDefaultMini).findFirst().get();
    }
}
