package cn.quantgroup.xyqb.model;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.entity.Contact;
import java.io.Serializable;
import java.util.Optional;
import lombok.Data;

/**
 * 联系人数据模型
 *
 * @author renwc
 * @date 2018-01-04
 */
@Data
public class ContactModel implements Serializable {
    private static final long serialVersionUID = -1L;

    private String name;
    private String phoneNo;
    private String relationName;
    private String relation;

    private ContactModel() {
    }

    public static ContactModel entity2Model(Contact entity) {
        if (entity == null) {
            return null;
        }
        ContactModel model = new ContactModel();
        model.setName(entity.getName());
        model.setPhoneNo(entity.getPhoneNo());
        model.setRelationName(Optional.ofNullable(entity.getRelation()).orElse(Relation.OTHER).getDesc());
        model.setRelation(entity.getRelation().name());
        return model;
    }
}
