package cn.quantgroup.xyqb.controller.modifyphoneno.resp;

import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.sql.Timestamp;
import java.util.Date;
import lombok.Data;

/**
 * Date: 2019/11/4
 * Time: 上午11:46
 *
 * @author: yangrui
 */
@Data
public class ModifyPhoneNoResp {

    private static final long serialVersionUID = 0x93c999d06b6f64d2L;


    private Long id;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Timestamp createdAt;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Timestamp updatedAt;

    /**
     * user.id
     */
    private Long userId;

    /**
     * 注册人真实姓名
     */
    private String name;

    /**
     * 注册人身份证件号
     */
    private String idCard;

    /**
     * 原手机号码
     */
    private String prevPhoneNo;

    /**
     * 新手机号码
     */
    private String curPhoneNo;

    /**
     * 身份证正面
     */
    private String idCardFaceUrl;

    /**
     * 身份证背面
     */
    private String idCardRearUrl;

    /**
     * 本人手持身份证照片
     */
    private String idCardHoldUrl;

    /**
     * 申请状态 0处理中; 1修改完成; 2不允许修改;
     */
    private Integer applyStatus;

    /**
     * 申请状态补充原因
     */
    private String applyStatusReason;

    /**
     * 处理状态 0待人工处理 1待用户反馈结果 2已反馈
     */
    private Integer processingStatus;
    /**
     * 申请来源
     */
    private Integer applySource;

    public static ModifyPhoneNoResp from(ModifyPhoneNo modifyPhoneNo){
        ModifyPhoneNoResp modifyPhoneNoResp = new ModifyPhoneNoResp();
        modifyPhoneNoResp.setId(modifyPhoneNo.getId());
        modifyPhoneNoResp.setCreatedAt(modifyPhoneNo.getCreatedAt());
        modifyPhoneNoResp.setUpdatedAt(modifyPhoneNo.getUpdatedAt());
        modifyPhoneNoResp.setUserId(modifyPhoneNo.getUserId());
        modifyPhoneNoResp.setName(modifyPhoneNo.getName());
        modifyPhoneNoResp.setIdCard(modifyPhoneNo.getIdCard());
        modifyPhoneNoResp.setPrevPhoneNo(modifyPhoneNo.getPrevPhoneNo());
        modifyPhoneNoResp.setCurPhoneNo(modifyPhoneNo.getCurPhoneNo());
        modifyPhoneNoResp.setIdCardFaceUrl(modifyPhoneNo.getIdCardFaceUrl());
        modifyPhoneNoResp.setIdCardRearUrl(modifyPhoneNo.getIdCardRearUrl());
        modifyPhoneNoResp.setIdCardHoldUrl(modifyPhoneNo.getIdCardHoldUrl());
        modifyPhoneNoResp.setApplyStatus(modifyPhoneNo.getApplyStatus());
        modifyPhoneNoResp.setApplyStatusReason(modifyPhoneNo.getApplyStatusReason());
        modifyPhoneNoResp.setProcessingStatus(modifyPhoneNo.getProcessingStatus());
        modifyPhoneNoResp.setApplySource(modifyPhoneNo.getApplySource().ordinal());
        return modifyPhoneNoResp;
    }
}
