package cn.quantgroup.xyqb.event;

import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserVccRegister;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.user.IUserVccRegisterService;

@Component
public class VccRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Autowired
    private IUserVccRegisterService userVccRegisterService;


    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        User user = userRegisterParam.getUser();
        Long vccRegisterChannelId = userRegisterParam.getVccRegisterChannelId();
        // vcc推广时存在推广渠道ID时保存下来
        if (Objects.isNull(user) || Objects.isNull(vccRegisterChannelId)) {
            return;
        }
        UserVccRegister userVccRegister = new UserVccRegister();
        userVccRegister.setUserId(user.getId());
        userVccRegister.setVccRegisterChannelId(vccRegisterChannelId);
        userVccRegister.setIsActive(true);
        userVccRegisterService.save(userVccRegister);
    }
}
