package cn.quantgroup.xyqb.config.mq;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * Created by xuran on 2017/9/7.
 */
@Configuration
public class RegisterMqConfig {
  @Value("${register.rabbitmq.queue}")
  private String queueName;
  @Value("${register.rabbitmq.exchange}")
  private String registerMqExchange;

  @Value("${register.rabbitmq.connection.host}")
  private String host;
  @Value("${register.rabbitmq.connection.port}")
  private Integer port;
  @Value("${register.rabbitmq.connection.user}")
  private String user;
  @Value("${register.rabbitmq.connection.password}")
  private String password;
  @Value("${register.rabbitmq.connection.virtual-host}")
  private String virtualHost;



  @Bean(name = "registerMqFactory")
  public ConnectionFactory registerMqFactory() {
    CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
    connectionFactory.setChannelCacheSize(1024);
    connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
    connectionFactory.setChannelCacheSize(180 * 1000);
    connectionFactory.setConnectionCacheSize(1024);
    connectionFactory.setUsername(user);
    connectionFactory.setPassword(password);
    connectionFactory.setVirtualHost(virtualHost);
    connectionFactory.setPublisherReturns(false);
    connectionFactory.setPublisherConfirms(false);
    return connectionFactory;
  }

  @Bean(name= "registerMqAmqpAdmin")
  public AmqpAdmin registerMqAmqpAdmin(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
    return new RabbitAdmin(registerMqFactory);
  }

  @Bean(name = "registerMqExchange")
  public FanoutExchange registerMqExchange() {
    return new FanoutExchange(registerMqExchange);
  }

  @Bean(name = "registerMqQueue")
  public Queue registerMqQueue() {
    return new Queue(queueName);
  }

  @Bean(name = "registerMqBinding")
  public Binding registerMqBinding(@Qualifier("registerMqAmqpAdmin")AmqpAdmin registerMqAmqpAdmin, @Qualifier("registerMqQueue")Queue registerMqQueue, @Qualifier("registerMqExchange")FanoutExchange registerMqExchange) {
    Binding binding = BindingBuilder.bind(registerMqQueue).to(registerMqExchange);
    registerMqAmqpAdmin.declareBinding(binding);
    return binding;
  }


  @Bean(name = "registerRabbitTemplate")
  public RabbitTemplate registerTemplate(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
    RabbitTemplate template = new RabbitTemplate(registerMqFactory);
    template.setExchange(registerMqExchange);
    return template;
  }
}
