package cn.quantgroup.xyqb.controller.internal.token;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * 发放一次性令牌
 *
 * @author 任文超
 * @version 1.0.0
 * @since 2017-10-31
 */
@RestController
@RequestMapping("/token")
public class OneTimeTokenController implements IBaseController {

  private static final Long SECONDS = 1 * 60L;

  @Autowired
  @Qualifier("stringRedisTemplate")
  private RedisTemplate<String, String> redisTemplate;

  /**
   * 发放一枚一次性令牌
   * One-Time Token用法：http请求首部行添加参数{One-Time-Token 6ac0665b-e19c-4392-a244-7b61690833f5}
   *
   * @return 一次性令牌
   */
  @RequestMapping(value = "/oneTime")
  public JsonResult oneTimeToken() {
    String token = UUID.randomUUID().toString();
    redisTemplate.opsForValue().set(token, Boolean.TRUE.toString(), SECONDS, TimeUnit.SECONDS);
    return JsonResult.buildSuccessResult("", token);
  }

}
