package cn.quantgroup.xyqb.config.captcha;

import cn.quantgroup.xyqb.thirdparty.jcaptcha.CustomGimpyFactory;
import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.backgroundgenerator.UniColorBackgroundGenerator;
import com.octo.captcha.component.image.color.RandomListColorGenerator;
import com.octo.captcha.component.image.color.SingleColorGenerator;
import com.octo.captcha.component.image.deformation.ImageDeformation;
import com.octo.captcha.component.image.deformation.ImageDeformationByFilters;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.fontgenerator.RandomFontGenerator;
import com.octo.captcha.component.image.textpaster.DecoratedRandomTextPaster;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.textpaster.textdecorator.BaffleTextDecorator;
import com.octo.captcha.component.image.textpaster.textdecorator.TextDecorator;
import com.octo.captcha.component.image.wordtoimage.DeformedComposedWordToImage;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import com.octo.captcha.component.word.wordgenerator.RandomWordGenerator;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import com.octo.captcha.engine.image.ListImageCaptchaEngine;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.ImageFilter;

/**
 * 类名称：CustomCaptchaEngine
 * 类描述：
 *
 * @author 李宁
 * @version 1.0.0
 * 创建时间：15/11/17 12:04
 * 修改人：
 * 修改时间：15/11/17 12:04
 * 修改备注：
 */
public class CustomCaptchaEngine extends ListImageCaptchaEngine {

    private static final int MIN_WORD_LEN = 4;
    private static final int MAX_WORD_LEN = 4;

    @Override
    protected void buildInitialFactories() {
        int minWordLength = 4;
        int maxWordLength = 4;
        int fontSize = 16;
        int imageWidth = 80;
        int imageHeight = 28;
        WordGenerator wordGenerator = new RandomWordGenerator("1234567890");
        SingleColorGenerator colorGenerator = new SingleColorGenerator(Color.WHITE);

        //文字干扰器--- 可以创建多个
        BaffleTextDecorator baffleTextDecorator = new BaffleTextDecorator(1, colorGenerator, 1);//气泡干扰
//        LineTextDecorator lineTextDecorator = new LineTextDecorator(1,colorGenerator, 1);//曲线干扰
//        TextDecorator[] textDecorators = new TextDecorator[]{baffleTextDecorator, lineTextDecorator};
        TextDecorator[] textDecorators = new TextDecorator[]{baffleTextDecorator};

        TextPaster randomPaster = new DecoratedRandomTextPaster(minWordLength,
                maxWordLength, new RandomListColorGenerator(new Color[]{
                new Color(23, 170, 27), new Color(220, 34, 11),
                new Color(23, 67, 172)}), textDecorators);

        BackgroundGenerator background = new UniColorBackgroundGenerator(imageWidth, imageHeight, colorGenerator);
        FontGenerator font = new RandomFontGenerator(fontSize, fontSize,
                new Font[]{new Font("nyala", Font.BOLD, fontSize),
                        new Font("Bell MT", Font.PLAIN, fontSize),
                        new Font("Credit valley", Font.BOLD, fontSize)});

        ImageDeformation postDef = new ImageDeformationByFilters(new ImageFilter[]{});
        ImageDeformation backDef = new ImageDeformationByFilters(new ImageFilter[]{});
        ImageDeformation textDef = new ImageDeformationByFilters(new ImageFilter[]{});

        WordToImage word2image = new DeformedComposedWordToImage(font,
                background, randomPaster, backDef, textDef, postDef);
        addFactory(new CustomGimpyFactory(wordGenerator, word2image));
    }


}
