package cn.quantgroup.xyqb.config.mq;

import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory.CacheMode;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by xuran on 2017/9/7.
 */
@Configuration
public class RegisterMqConfig {
    @Value("${register.rabbitmq.queue}")
    private String queueName;
    @Value("${register.rabbitmq.exchange}")
    private String registerMqExchange;
    @Value("${register.rabbitmq.queue.qq_gdt}")
    private String queueName4Gdt;
    @Value("${register.rabbitmq.routing_key.qq_gdt}")
    private String routingKey4Gdt;
    @Value("${register.rabbitmq.exchange.qq_gdt}")
    private String exchange4Gdt;

    @Value("${register.rabbitmq.connection.host}")
    private String host;
    @Value("${register.rabbitmq.connection.port}")
    private Integer port;
    @Value("${register.rabbitmq.connection.user}")
    private String user;
    @Value("${register.rabbitmq.connection.password}")
    private String password;
    @Value("${register.rabbitmq.connection.virtual-host}")
    private String virtualHost;


    @Bean(name = "registerMqFactory")
    public ConnectionFactory registerMqFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Bean(name = "registerMqAmqpAdmin")
    public AmqpAdmin registerMqAmqpAdmin(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
        return new RabbitAdmin(registerMqFactory);
    }

    @Bean(name = "registerMqExchange")
    public FanoutExchange registerMqExchange() {
        return new FanoutExchange(registerMqExchange);
    }

    @Bean(name = "registerMqQueue")
    public Queue registerMqQueue() {
        return new Queue(queueName);
    }

    @Bean(name = "registerMqBinding")
    public Binding registerMqBinding(@Qualifier("registerMqAmqpAdmin") AmqpAdmin registerMqAmqpAdmin, @Qualifier("registerMqQueue") Queue registerMqQueue, @Qualifier("registerMqExchange") FanoutExchange registerMqExchange) {
        Binding binding = BindingBuilder.bind(registerMqQueue).to(registerMqExchange);
        registerMqAmqpAdmin.declareBinding(binding);
        return binding;
    }

    @Bean(name = "registerRabbitTemplate")
    public RabbitTemplate registerTemplate(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
        RabbitTemplate template = new RabbitTemplate(registerMqFactory);
        template.setExchange(registerMqExchange);
        return template;
    }


    @Bean(name = "registerMqExchange4Gdt")
    public FanoutExchange registerMqExchange4Gdt() {
        return new FanoutExchange(exchange4Gdt);
    }

    @Bean(name = "registerMqQueue4Gdt")
    public Queue registerMqQueue4Gdt() {
        return new Queue(queueName4Gdt);
    }

    @Bean(name = "registerMqBinding4Gdt")
    public Binding registerMqBinding4Gdt(@Qualifier("registerMqAmqpAdmin") AmqpAdmin registerMqAmqpAdmin, @Qualifier("registerMqQueue4Gdt") Queue registerMqQueue4Gdt, @Qualifier("registerMqExchange4Gdt") FanoutExchange registerMqExchange4Gdt) {
        Binding binding = BindingBuilder.bind(registerMqQueue4Gdt).to(registerMqExchange4Gdt);
        registerMqAmqpAdmin.declareBinding(binding);
        return binding;
    }


    @Bean(name = "registerRabbitTemplate4Gdt")
    public RabbitTemplate registerTemplate4Gdt(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
        RabbitTemplate template = new RabbitTemplate(registerMqFactory);
        template.setExchange(exchange4Gdt);
        return template;
    }

    @Bean(name = "commonConnectionFactory")
    public ConnectionFactory commonConnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setCacheMode(CacheMode.CHANNEL);
        //根据使用情况动态调整。
        connectionFactory.setChannelCacheSize(100);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost("/");
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Bean(name = "wechatRabbitTemplate")
    public RabbitTemplate wechatRabbitTemplate(@Qualifier("commonConnectionFactory") ConnectionFactory commonConnectionFactory) {
        RabbitTemplate rabbitTemplate =  new RabbitTemplate(commonConnectionFactory);
        rabbitTemplate.setMessageConverter(new Jackson2JsonMessageConverter());
        RabbitAdmin rabbitAdmin = new RabbitAdmin(commonConnectionFactory);
        String queueName = "wechat_bind";
        Map<String, Object> queueArgs = new HashMap<>();
        //数据 1 天有效期
        queueArgs.put("x-message-ttl", 24 * 60 * 60 * 1000);
        Queue wechatBind = new Queue(queueName, true, false, false, queueArgs);
        rabbitAdmin.declareQueue(wechatBind);
//        rabbitTemplate.setQueue(queueName);
        rabbitTemplate.setRoutingKey(queueName);
        return rabbitTemplate;
    }

}
