package cn.quantgroup.xyqb.service.wechat;

import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.model.webchat.AccessTokenResponse;

import java.util.List;

/**
 * Created by Miraculous on 2017/1/19.
 */
public interface IWechatService {
    AccessTokenResponse getToken(String code,String appId,Integer tenantId);

    WechatUserInfo getWechatUserInfoFromWechatServer(String token, String openId,String appId,Integer tenantId);

    WechatUserInfo findWechatUserInfoFromDb(String openId,String appId,Integer tenantId);
    List<WechatUserInfo> findWechatUserInfoFromDb(List<String> openId,String appId,Integer tenantId);
    List<WechatUserInfo> findUnionIdsAndOpenIdAndTenantId(List<String> uuids,String appId,Integer tenantId);


    WechatUserInfo findByUnionIdAndAppIdAndTenantId(String unionId,String appId,Integer tenantId);

    WechatUserInfo findWechatUserInfoByPhoneNo(String phoneNo, Integer tenantId);

    WechatUserInfo saveWechatUserInfo(WechatUserInfo userInfo);

    /**
     * 关联用户和微信
     *
     * @param userId  - 用户标识
     * @param phoneNo
     * @param openId  - 微信标识
     * @return
     */
    int relateUser(Long userId, String phoneNo, String openId,String appId,Integer tenantId);

    /**
     * 按userId查微信信息
     * 此接口实现处不应加缓存，否则解绑时（在关联用户的事务中）不好清除
     *
     * @param userId - 用户标识
     * @return
     */
    WechatUserInfo queryByUserId(Long userId,Integer tenantId);

    WechatUserInfo queryByUserId(Long userId, String appName,String appId,Integer tenantId);

    int forbiddenUserWeChat(Long userId, Integer tenantId);


    List<WechatUserInfo> queryListByUserId(Long userId,Integer tenantId);
    WechatUserInfo queryByUserIdAndAppId(Long userId,String appId,Integer tenantId);
    List<WechatUserInfo> queryListByUserIdAndAppId(List<Long> userIds,String appId,Integer tenantId);

    List<WechatUserInfo> queryListByUnionId(String unionId,Integer tenantId);

    List<WechatUserInfo> queryListByUnionIds(List<String> unionIds,Integer tenantId);

    List<WechatUserInfo> queryByUserIdsAndAppName(List<Long> userIds, String appName,Integer tenantId);
}
