package cn.quantgroup.xyqb.session;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;
import cn.quantgroup.xyqb.util.IpUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.UUID;

/**
 * Created by Miraculous on 2016/12/29.
 */
@Slf4j
public class XyqbSessionContextHolder {

    private static final ThreadLocal<SessionStruct> threadSession = new ThreadLocal<>();
    private static RedisTemplate<String, String> redisTemplate = null;

    public static void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        XyqbSessionContextHolder.redisTemplate = redisTemplate;
    }

    public static SessionStruct getXSession() {
        SessionStruct sessionStruct;
        if (threadSession.get() != null) {
            sessionStruct = threadSession.get();
        } else {
            sessionStruct = getXSessionFromRedis();
            threadSession.set(sessionStruct);
        }
        if (sessionStruct != null && sessionStruct.getValues() != null && sessionStruct.getValues().getLoginProperties() != null) {
            sessionStruct.setStmsUserId(sessionStruct.getValues().getLoginProperties().getStmsUserId());
            sessionStruct.setStmsUserName(sessionStruct.getValues().getLoginProperties().getStmsUserName());
        }

        return sessionStruct;
    }

    public static SessionStruct initXSession() {
        SessionStruct sessionStruct = threadSession.get();

        if (sessionStruct == null) {
            sessionStruct = new SessionStruct();
            sessionStruct.setSid(UUID.randomUUID().toString());
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String tenantId = request.getHeader(Constants.X_AUTH_TENANT);
            String registered_from = request.getHeader(Constants.X_AUTH_FROM);
            String ip = IpUtil.getRemoteIP(request);
            sessionStruct.setTenantId(Integer.valueOf(tenantId));
            sessionStruct.setRegisteredFrom(Long.valueOf(registered_from));
            sessionStruct.setIp(ip);

            //如果是极验，那赋值
            if (request.getHeader(Constants.X_BEHAVIOR_TYPE) != null && "1".equals(request.getHeader(Constants.X_BEHAVIOR_TYPE))) {
                String geetestId = request.getHeader(Constants.X_BEHAVIOR_ID);
                sessionStruct.setGeetestId(geetestId);
            }
            sessionStruct.setScDeviceId(request.getHeader("scDeviceId"));
            sessionStruct.setTerminal(request.getHeader("terminal"));

            SessionValue sessionValue = new SessionValue();
            LoginProperties loginProperties = new LoginProperties();
            loginProperties.setTenantId(Integer.valueOf(tenantId));
            loginProperties.setCreatedFrom(Long.valueOf(registered_from));
            sessionValue.setLoginProperties(loginProperties);
            sessionStruct.setValues(sessionValue);

            threadSession.set(sessionStruct);
        } else {
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

            //如果是极验，那赋值
            if (request.getHeader(Constants.X_BEHAVIOR_TYPE) != null && "1".equals(request.getHeader(Constants.X_BEHAVIOR_TYPE))) {
                String geetestId = request.getHeader(Constants.X_BEHAVIOR_ID);
                sessionStruct.setGeetestId(geetestId);
            }
        }
        return sessionStruct;
    }

    public static SessionStruct initSTMSSession(String token1, String userId1, String userName1) {
        SessionStruct sessionStruct = threadSession.get();
        if (sessionStruct == null) {

            sessionStruct = new SessionStruct();
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String tenantId = request.getHeader(Constants.X_AUTH_TENANT);
            String registered_from = request.getHeader(Constants.X_AUTH_FROM);

            if (cn.quantgroup.xyqb.util.StringUtils.isEmpty(registered_from)) {
                //TODO:唐峰，先默认给0
                registered_from = "0";
            }
            String ip = IpUtil.getRemoteIP(request);
            sessionStruct.setTenantId(Integer.valueOf(tenantId));
            sessionStruct.setRegisteredFrom(Long.valueOf(registered_from));
            sessionStruct.setIp(ip);
            sessionStruct.setScDeviceId(request.getHeader("scDeviceId"));
            sessionStruct.setTerminal(request.getHeader("terminal"));
            //sessionStruct.setSid(token);
            //sessionStruct.setStmsUserId(userId);
            //sessionStruct.setStmsUserName(userName);
            threadSession.set(sessionStruct);
        } else {
            //sessionStruct.setStmsUserId(userId);
            //sessionStruct.setStmsUserName(userName);
        }
        SessionValue sessionValue = sessionStruct.getValues();
        if (sessionValue == null) {
            sessionValue = new SessionValue();
            LoginProperties loginProperties = new LoginProperties();
            //loginProperties.setStmsUserId(userId);
            //loginProperties.setStmsUserName(userName);
            sessionValue.setLoginProperties(loginProperties);
        }
        sessionStruct.setValues(sessionValue);

        return sessionStruct;
    }

    public static SessionStruct getXSessionFromRedis() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String token = request.getHeader(Constants.X_AUTH_TOKEN);
        String from = request.getHeader(Constants.X_AUTH_FROM);
        try {
            from = StringUtils.isEmpty(from) ? request.getHeader(Constants.X_AUTH_FROM_) : from;
        } catch (Exception e) {
            from = "0";
        }
        int tenantId= UserConstant.defaultTenantId;
        String tenantIdString = request.getHeader(Constants.X_AUTH_TENANT);
        if(StringUtils.isNotEmpty(tenantIdString)){
            tenantId = Integer.parseInt(tenantIdString);
        }
        return getXSessionFromRedis(token,tenantId,StringUtils.isEmpty(from) ? null:Long.valueOf(from));
    }

    public static String getXSessionFromTenantRedis() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        return request.getHeader(Constants.X_AUTH_TENANT);
    }

    public static SessionStruct getXSessionFromRedis(String token,Integer tenantId,Long registeredFrom) {
        String linkToken;
        if (UserConstant.defaultTenantId.equals(tenantId)) {
            linkToken = Constants.Session.USER_SESSION_CACHE + token;
        } else {
            linkToken = Constants.Session.USER_SESSION_CACHE + tenantId + ":" + token;
        }

        String result = redisTemplate.opsForValue().get(linkToken);
        if (StringUtils.isEmpty(result)) {
            log.warn("[XyqbSessionContextHolder][getXSessionFromRedis] session data 未找到：Tokekn:{},linkTokekn:{},sessionValue:{}", token, linkToken, result);
            return null;
        }
        try {
            SessionValue values = JSON.parseObject(result, SessionValue.class);
            SessionStruct sessionStruct = new SessionStruct();
            if (values == null) {
                log.warn("[XyqbSessionContextHolder][getXSessionFromRedis] session data 序列化失败：token:{},linkTokekn:{},sessionValue:{}", token, linkToken, result);
                return null;
            } else {
                if (values.getLoginProperties() != null) {
                    sessionStruct.setTenantId(values.getLoginProperties().getTenantId());
                    //sessionStruct.setRegisteredFrom(values.getLoginProperties().getCreatedFrom());
                    sessionStruct.setRegisteredFrom(registeredFrom);
                }
            }
            sessionStruct.setSid(token);
            sessionStruct.setValues(values);
            sessionStruct.setExpire(redisTemplate.getExpire(Constants.Session.USER_SESSION_CACHE + token));
            return sessionStruct;
        } catch (Exception e) {
            log.warn("[XyqbSessionContextHolder][getXSessionFromRedis] 序列化SessionValue出错：Tokekn:{},linkTokekn:{},sessionValue:{}", token, linkToken, result, e);
            return null;
        }
    }

    public static void releaseSession() {
        threadSession.remove();
    }
}
