package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.config.data.WechatConfiguration;
import cn.quantgroup.xyqb.constant.enums.LoginType;
import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.WechatConfigBean;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.v2.login.BaseLoginParam;
import cn.quantgroup.xyqb.model.v2.login.WechatMiniLoginParam;
import cn.quantgroup.xyqb.remote.WechatRemoteService;
import cn.quantgroup.xyqb.repository.IWeChatUserRepository;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.lang.reflect.Type;
import java.util.Map;

/**
 * 微信小程序登录
 */
@Service
@Slf4j
public class WechatMiniLoginStrategy implements LoginStrategy{

    private final WechatRemoteService wechatRemoteService;
    private final WechatConfiguration wechatConfiguration;

    private final IWeChatUserRepository weChatUserRepository;
    private final ISessionService sessionService;
    private final Gson gson;

    public WechatMiniLoginStrategy(WechatRemoteService wechatRemoteService, WechatConfiguration wechatConfiguration, IWeChatUserRepository weChatUserRepository, ISessionService sessionService, Gson gson) {
        this.wechatRemoteService = wechatRemoteService;
        this.wechatConfiguration = wechatConfiguration;
        this.weChatUserRepository = weChatUserRepository;
        this.sessionService = sessionService;
        this.gson = gson;
    }

    @Override
    public Integer getType() {
        return 2101;
    }

    @Override
    public LoginBean login(BaseLoginParam param) {
        WechatMiniLoginParam loginParam = (WechatMiniLoginParam)param;
        SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();

        //1、微信登录逻辑
        WechatConfigBean wechatConfigBean = wechatConfiguration.getByAppIdAndTenantId(loginParam.getAppId(),sessionStruct.getTenantId());
        String response =wechatRemoteService.login(wechatConfigBean.getAppId(),wechatConfigBean.getAppSecret(),((WechatMiniLoginParam) param).getCode());

        Type resultType = new TypeToken<Map<String, String>>() {
        }.getType();

        Map<String, String> responseMap = gson.fromJson(response, resultType);

        String openid,sessionKey,unionId;


        assert responseMap != null;
        if (responseMap.containsKey("errcode") && Integer.parseInt(responseMap.get("errcode")) != 0) {
            log.error("code:{},errcode:{},errmsg:{}", ((WechatMiniLoginParam) param).getCode(), responseMap.get("errcode"),
                    responseMap.get("errmsg"));
            throw new BizException(BizExceptionEnum.ERROR_WECHAT_LOGIN,responseMap.get("errmsg"));
        } else {
            openid = responseMap.get("openid");
            if (responseMap.containsKey("session_key")) {
                sessionKey = responseMap.get("session_key");
            }
            if (responseMap.containsKey("unionid")) {
                unionId = responseMap.get("unionid");
            }
        }

        //2、登录判断逻辑
        WechatUserInfo wechatUserInfo = weChatUserRepository.findByOpenIdAndAppIdAndTenantId(openid,loginParam.getAppId(),sessionStruct.getTenantId());
        boolean register =false;
        if(wechatUserInfo ==null){
            //首次登录
            register = true;

        }else{
//            wechatUserInfo = weChatUserRepository.save(null);

        }
//        LoginProperties loginProperties = new LoginProperties(1, sessionStruct.getRegisteredFrom(), sessionStruct.getTenantId());
//        AuthBean authBean = sessionService.createSession(user, loginProperties, LoginType.ACCOUNTPASSWORD.ordinal(), sessionStruct.getTenantId());
//        LoginBean loginBean = new LoginBean();
//        if (authBean != null) {
//            loginBean.setToken(authBean.getToken());
//            loginBean.setPhoneNo(authBean.getPhoneNo());
//            loginBean.setUuid(authBean.getUuid());
//            loginBean.setHasPassword(authBean.isHasPassword());
//            loginBean.setUserId(wechatUserInfo.getUserId());
//            loginBean.setTenantId(wechatUserInfo.getTenantId());
//        }
//        loginBean.setRegister(register);
//


        return null;
    }

    @Override
    public BaseLoginParam checkParam(LoginReq loginReq) {
        WechatMiniLoginParam param = loginReq.getData().toJavaObject(WechatMiniLoginParam.class);
        validator.validate(param);
        return param;
    }

}
